package com.els.base.inquiry.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value="询报价-询价单-采购方附件")
public class InquiryPurFile implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("附件类型，1表示公有，2表示私有")
    private Integer type;

    @ApiModelProperty("采购方询价单头ID")
    private String purOrderId;

    @ApiModelProperty("采购方询价单行项目编号，针对私有附件")
    private String purOrderItemNo;

    @ApiModelProperty("物料类型，共M001，M002，M003，M004四种类型")
    private String materialType;

    @ApiModelProperty("来源，1表示来自PLM，2表示来自本地上传")
    private Integer sources;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("附件json字符串")
    private String attachments;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getPurOrderItemNo() {
        return purOrderItemNo;
    }

    public void setPurOrderItemNo(String purOrderItemNo) {
        this.purOrderItemNo = purOrderItemNo == null ? null : purOrderItemNo.trim();
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType == null ? null : materialType.trim();
    }

    public Integer getSources() {
        return sources;
    }

    public void setSources(Integer sources) {
        this.sources = sources;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getAttachments() {
        return attachments;
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments == null ? null : attachments.trim();
    }
}