package com.els.base.inquiry.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value="询报价-设置报价阶梯")
public class InquiryQuoteLadder implements Serializable {
    @ApiModelProperty("ID主键")
    private String id;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("数量从")
    private Integer numberFrom;

    @ApiModelProperty("数量到")
    private Integer numberTo;

    @ApiModelProperty("所属类型，1属于物料，2属于询价单行")
    private Integer belongType;

    @ApiModelProperty("所关联物料id")
    private String targetId;

    @ApiModelProperty("所关联询价单行id")
    private String itemId;

    @ApiModelProperty("不含税价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("排序")
    private Integer sortNo;

    @ApiModelProperty("阶梯报价的创建方，SUP供应方，PUR采购方")
    private String createCompanyType;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public Integer getNumberFrom() {
        return numberFrom;
    }

    public void setNumberFrom(Integer numberFrom) {
        this.numberFrom = numberFrom;
    }

    public Integer getNumberTo() {
        return numberTo;
    }

    public void setNumberTo(Integer numberTo) {
        this.numberTo = numberTo;
    }

    public Integer getBelongType() {
        return belongType;
    }

    public void setBelongType(Integer belongType) {
        this.belongType = belongType;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId == null ? null : targetId.trim();
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId == null ? null : itemId.trim();
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getCreateCompanyType() {
        return createCompanyType;
    }

    public void setCreateCompanyType(String createCompanyType) {
        this.createCompanyType = createCompanyType == null ? null : createCompanyType.trim();
    }
}