package com.els.base.inquiry.entity;

import java.util.Date;

import com.els.base.inquiry.utils.json.SupOrderJsonDeserialzer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonDeserialize(using=SupOrderJsonDeserialzer.class)
@ApiModel(value="询报价-供应商-表头")
public class InquirySupOrder extends AbstractInquiryOrder {
	
	/**-----------以下不是自动生成，请不要覆盖------------------**/
	/**-----------以上不是自动生成，请不要覆盖------------------**/
    
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("询价单类型 ：物料M001,模具M002，包装类M003")
    private String type;

    @ApiModelProperty("询价单模板id")
    private String templateId;

    @ApiModelProperty("询价单-采购方头id")
    private String purOrderId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("询价单号")
    private String orderNo;

    @ApiModelProperty("摘要说明")
    private String digestExplain;

    @ApiModelProperty("创建日期")
    private Date createDate;

    @ApiModelProperty("发布日期")
    private Date publishDate;

    @ApiModelProperty("报价起始日期")
    private Date quoteStartDate;

    @ApiModelProperty("报价截止日期")
    private Date quoteEndDate;

    @ApiModelProperty("询价单状态，1已发布，2已冻结，3已接受，4部分接受，5已拒绝，6已作废")
    private Integer inquiryOrderStatus;

    @ApiModelProperty("报价状态，1未报价，2已报价，4重报价")
    private Integer quoteStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("供应商公司ID")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商用户ID")
    private String supUserId;

    @ApiModelProperty("供应商名称")
    private String supUserName;

    @ApiModelProperty("创建者公司ID")
    private String purCompanyId;

    @ApiModelProperty("创建者公司名称")
    private String purCompanyName;

    @ApiModelProperty("创建者ID")
    private String purUserId;

    @ApiModelProperty("创建者名称")
    private String purUserName;
    
    @ApiModelProperty("审批状态，1未审批，2审批中，3审批通过，4审批驳回")
    private Integer auditStatus;

    @ApiModelProperty("报价时间")
    private Date quoteTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public String getDigestExplain() {
        return digestExplain;
    }

    public void setDigestExplain(String digestExplain) {
        this.digestExplain = digestExplain == null ? null : digestExplain.trim();
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getQuoteStartDate() {
        return quoteStartDate;
    }

    public void setQuoteStartDate(Date quoteStartDate) {
        this.quoteStartDate = quoteStartDate;
    }

    public Date getQuoteEndDate() {
        return quoteEndDate;
    }

    public void setQuoteEndDate(Date quoteEndDate) {
        this.quoteEndDate = quoteEndDate;
    }

    public Integer getInquiryOrderStatus() {
        return inquiryOrderStatus;
    }

    public void setInquiryOrderStatus(Integer inquiryOrderStatus) {
        this.inquiryOrderStatus = inquiryOrderStatus;
    }

    public Integer getQuoteStatus() {
        return quoteStatus;
    }

    public void setQuoteStatus(Integer quoteStatus) {
        this.quoteStatus = quoteStatus;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }
    
    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
}