package com.els.base.inquiry.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.xml.bind.annotation.XmlTransient;

@ApiModel(value="询报价-待询价物料")
public class InquiryWaitMaterial implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;
    
    @ApiModelProperty("信息类别")
    private String infoCategory;
    
    @ApiModelProperty("采购申请")
    private String purchaseApply;

    @ApiModelProperty("项目")
    private String project;

    @ApiModelProperty("工厂")
    private String factory;

    @ApiModelProperty("物料编号")
    private String materialCode;

    @ApiModelProperty("短文本")
    private String shortText;

    @ApiModelProperty("申请数量")
    private BigDecimal applyQuantity;

    @ApiModelProperty("基本单位")
    private String basicUnit;

    @ApiModelProperty("采购数量")
    private BigDecimal purchaseQuantity;

    @ApiModelProperty("已订购")
    private BigDecimal orderedQuantity;

    @ApiModelProperty("Un")
    private String un;

    @ApiModelProperty("S")
    private String s;

    @ApiModelProperty("类")
    private String category;

    @ApiModelProperty("凭证类型")
    private String voucherType;

    @ApiModelProperty("需求日期")
    private Date demandDate;

    @ApiModelProperty("交货日期")
    private Date deliveryDate;

    @ApiModelProperty("批准日期")
    private Date approveDate;

    @ApiModelProperty("创建者")
    private String creator;

    @ApiModelProperty("需求者")
    private String demander;

    @ApiModelProperty("PGr")
    private String pgr;

    @ApiModelProperty("跟踪号")
    private String trackingNo;

    @ApiModelProperty("物料组")
    private String materialGroup;

    @ApiModelProperty("更改日期")
    private Date updateDate;

    @ApiModelProperty("批准状态")
    private String approveStatus;

    @ApiModelProperty("是否创建询价单，1是，0否")
    private Integer isCreateInquiryOrder;

    @ApiModelProperty("询价单号")
    private String inquiryOrderNo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;

    @XmlTransient
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getInfoCategory() {
        return infoCategory;
    }

    public void setInfoCategory(String infoCategory) {
        this.infoCategory = infoCategory == null ? null : infoCategory.trim();
    }

	public String getPurchaseApply() {
        return purchaseApply;
    }

    public void setPurchaseApply(String purchaseApply) {
        this.purchaseApply = purchaseApply == null ? null : purchaseApply.trim();
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory == null ? null : factory.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getShortText() {
        return shortText;
    }

    public void setShortText(String shortText) {
        this.shortText = shortText == null ? null : shortText.trim();
    }

    public BigDecimal getApplyQuantity() {
        return applyQuantity;
    }

    public void setApplyQuantity(BigDecimal applyQuantity) {
        this.applyQuantity = applyQuantity;
    }

    public String getBasicUnit() {
        return basicUnit;
    }

    public void setBasicUnit(String basicUnit) {
        this.basicUnit = basicUnit == null ? null : basicUnit.trim();
    }

    public BigDecimal getPurchaseQuantity() {
        return purchaseQuantity;
    }

    public void setPurchaseQuantity(BigDecimal purchaseQuantity) {
        this.purchaseQuantity = purchaseQuantity;
    }

    public BigDecimal getOrderedQuantity() {
        return orderedQuantity;
    }

    public void setOrderedQuantity(BigDecimal orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public String getUn() {
        return un;
    }

    public void setUn(String un) {
        this.un = un == null ? null : un.trim();
    }

    public String getS() {
        return s;
    }

    public void setS(String s) {
        this.s = s == null ? null : s.trim();
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category == null ? null : category.trim();
    }

    public String getVoucherType() {
        return voucherType;
    }

    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType == null ? null : voucherType.trim();
    }

    public Date getDemandDate() {
        return demandDate;
    }

    public void setDemandDate(Date demandDate) {
        this.demandDate = demandDate;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator == null ? null : creator.trim();
    }

    public String getDemander() {
        return demander;
    }

    public void setDemander(String demander) {
        this.demander = demander == null ? null : demander.trim();
    }

    public String getPgr() {
        return pgr;
    }

    public void setPgr(String pgr) {
        this.pgr = pgr == null ? null : pgr.trim();
    }

    public String getTrackingNo() {
        return trackingNo;
    }

    public void setTrackingNo(String trackingNo) {
        this.trackingNo = trackingNo == null ? null : trackingNo.trim();
    }

    public String getMaterialGroup() {
        return materialGroup;
    }

    public void setMaterialGroup(String materialGroup) {
        this.materialGroup = materialGroup == null ? null : materialGroup.trim();
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(String approveStatus) {
        this.approveStatus = approveStatus == null ? null : approveStatus.trim();
    }

    @XmlTransient
    public Integer getIsCreateInquiryOrder() {
        return isCreateInquiryOrder;
    }

    public void setIsCreateInquiryOrder(Integer isCreateInquiryOrder) {
        this.isCreateInquiryOrder = isCreateInquiryOrder;
    }

    @XmlTransient
    public String getInquiryOrderNo() {
        return inquiryOrderNo;
    }

    public void setInquiryOrderNo(String inquiryOrderNo) {
        this.inquiryOrderNo = inquiryOrderNo == null ? null : inquiryOrderNo.trim();
    }

    @XmlTransient
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}