package com.els.base.inquiry.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class InquiryWaitMaterialExample extends AbstractExample<InquiryWaitMaterial> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<InquiryWaitMaterial> pageView = new PageView<InquiryWaitMaterial>(1, 10);

    private static final long serialVersionUID = 1L;

    public InquiryWaitMaterialExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<InquiryWaitMaterial> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<InquiryWaitMaterial> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryIsNull() {
            addCriterion("INFO_CATEGORY is null");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryIsNotNull() {
            addCriterion("INFO_CATEGORY is not null");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryEqualTo(String value) {
            addCriterion("INFO_CATEGORY =", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryNotEqualTo(String value) {
            addCriterion("INFO_CATEGORY <>", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryGreaterThan(String value) {
            addCriterion("INFO_CATEGORY >", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryGreaterThanOrEqualTo(String value) {
            addCriterion("INFO_CATEGORY >=", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryLessThan(String value) {
            addCriterion("INFO_CATEGORY <", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryLessThanOrEqualTo(String value) {
            addCriterion("INFO_CATEGORY <=", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryLike(String value) {
            addCriterion("INFO_CATEGORY like", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryNotLike(String value) {
            addCriterion("INFO_CATEGORY not like", value, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryIn(List<String> values) {
            addCriterion("INFO_CATEGORY in", values, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryNotIn(List<String> values) {
            addCriterion("INFO_CATEGORY not in", values, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryBetween(String value1, String value2) {
            addCriterion("INFO_CATEGORY between", value1, value2, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andInfoCategoryNotBetween(String value1, String value2) {
            addCriterion("INFO_CATEGORY not between", value1, value2, "infoCategory");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyIsNull() {
            addCriterion("PURCHASE_APPLY is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyIsNotNull() {
            addCriterion("PURCHASE_APPLY is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyEqualTo(String value) {
            addCriterion("PURCHASE_APPLY =", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyNotEqualTo(String value) {
            addCriterion("PURCHASE_APPLY <>", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyGreaterThan(String value) {
            addCriterion("PURCHASE_APPLY >", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASE_APPLY >=", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyLessThan(String value) {
            addCriterion("PURCHASE_APPLY <", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyLessThanOrEqualTo(String value) {
            addCriterion("PURCHASE_APPLY <=", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyLike(String value) {
            addCriterion("PURCHASE_APPLY like", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyNotLike(String value) {
            addCriterion("PURCHASE_APPLY not like", value, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyIn(List<String> values) {
            addCriterion("PURCHASE_APPLY in", values, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyNotIn(List<String> values) {
            addCriterion("PURCHASE_APPLY not in", values, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyBetween(String value1, String value2) {
            addCriterion("PURCHASE_APPLY between", value1, value2, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andPurchaseApplyNotBetween(String value1, String value2) {
            addCriterion("PURCHASE_APPLY not between", value1, value2, "purchaseApply");
            return (Criteria) this;
        }

        public Criteria andProjectIsNull() {
            addCriterion("PROJECT is null");
            return (Criteria) this;
        }

        public Criteria andProjectIsNotNull() {
            addCriterion("PROJECT is not null");
            return (Criteria) this;
        }

        public Criteria andProjectEqualTo(String value) {
            addCriterion("PROJECT =", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectNotEqualTo(String value) {
            addCriterion("PROJECT <>", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectGreaterThan(String value) {
            addCriterion("PROJECT >", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT >=", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectLessThan(String value) {
            addCriterion("PROJECT <", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectLessThanOrEqualTo(String value) {
            addCriterion("PROJECT <=", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectLike(String value) {
            addCriterion("PROJECT like", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectNotLike(String value) {
            addCriterion("PROJECT not like", value, "project");
            return (Criteria) this;
        }

        public Criteria andProjectIn(List<String> values) {
            addCriterion("PROJECT in", values, "project");
            return (Criteria) this;
        }

        public Criteria andProjectNotIn(List<String> values) {
            addCriterion("PROJECT not in", values, "project");
            return (Criteria) this;
        }

        public Criteria andProjectBetween(String value1, String value2) {
            addCriterion("PROJECT between", value1, value2, "project");
            return (Criteria) this;
        }

        public Criteria andProjectNotBetween(String value1, String value2) {
            addCriterion("PROJECT not between", value1, value2, "project");
            return (Criteria) this;
        }

        public Criteria andFactoryIsNull() {
            addCriterion("FACTORY is null");
            return (Criteria) this;
        }

        public Criteria andFactoryIsNotNull() {
            addCriterion("FACTORY is not null");
            return (Criteria) this;
        }

        public Criteria andFactoryEqualTo(String value) {
            addCriterion("FACTORY =", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotEqualTo(String value) {
            addCriterion("FACTORY <>", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryGreaterThan(String value) {
            addCriterion("FACTORY >", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryGreaterThanOrEqualTo(String value) {
            addCriterion("FACTORY >=", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryLessThan(String value) {
            addCriterion("FACTORY <", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryLessThanOrEqualTo(String value) {
            addCriterion("FACTORY <=", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryLike(String value) {
            addCriterion("FACTORY like", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotLike(String value) {
            addCriterion("FACTORY not like", value, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryIn(List<String> values) {
            addCriterion("FACTORY in", values, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotIn(List<String> values) {
            addCriterion("FACTORY not in", values, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryBetween(String value1, String value2) {
            addCriterion("FACTORY between", value1, value2, "factory");
            return (Criteria) this;
        }

        public Criteria andFactoryNotBetween(String value1, String value2) {
            addCriterion("FACTORY not between", value1, value2, "factory");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeIsNull() {
            addCriterion("MATERIAL_CODE is null");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeIsNotNull() {
            addCriterion("MATERIAL_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeEqualTo(String value) {
            addCriterion("MATERIAL_CODE =", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotEqualTo(String value) {
            addCriterion("MATERIAL_CODE <>", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeGreaterThan(String value) {
            addCriterion("MATERIAL_CODE >", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_CODE >=", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeLessThan(String value) {
            addCriterion("MATERIAL_CODE <", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_CODE <=", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeLike(String value) {
            addCriterion("MATERIAL_CODE like", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotLike(String value) {
            addCriterion("MATERIAL_CODE not like", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeIn(List<String> values) {
            addCriterion("MATERIAL_CODE in", values, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotIn(List<String> values) {
            addCriterion("MATERIAL_CODE not in", values, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeBetween(String value1, String value2) {
            addCriterion("MATERIAL_CODE between", value1, value2, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_CODE not between", value1, value2, "materialCode");
            return (Criteria) this;
        }

        public Criteria andShortTextIsNull() {
            addCriterion("SHORT_TEXT is null");
            return (Criteria) this;
        }

        public Criteria andShortTextIsNotNull() {
            addCriterion("SHORT_TEXT is not null");
            return (Criteria) this;
        }

        public Criteria andShortTextEqualTo(String value) {
            addCriterion("SHORT_TEXT =", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextNotEqualTo(String value) {
            addCriterion("SHORT_TEXT <>", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextGreaterThan(String value) {
            addCriterion("SHORT_TEXT >", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextGreaterThanOrEqualTo(String value) {
            addCriterion("SHORT_TEXT >=", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextLessThan(String value) {
            addCriterion("SHORT_TEXT <", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextLessThanOrEqualTo(String value) {
            addCriterion("SHORT_TEXT <=", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextLike(String value) {
            addCriterion("SHORT_TEXT like", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextNotLike(String value) {
            addCriterion("SHORT_TEXT not like", value, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextIn(List<String> values) {
            addCriterion("SHORT_TEXT in", values, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextNotIn(List<String> values) {
            addCriterion("SHORT_TEXT not in", values, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextBetween(String value1, String value2) {
            addCriterion("SHORT_TEXT between", value1, value2, "shortText");
            return (Criteria) this;
        }

        public Criteria andShortTextNotBetween(String value1, String value2) {
            addCriterion("SHORT_TEXT not between", value1, value2, "shortText");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityIsNull() {
            addCriterion("APPLY_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityIsNotNull() {
            addCriterion("APPLY_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityEqualTo(BigDecimal value) {
            addCriterion("APPLY_QUANTITY =", value, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityNotEqualTo(BigDecimal value) {
            addCriterion("APPLY_QUANTITY <>", value, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityGreaterThan(BigDecimal value) {
            addCriterion("APPLY_QUANTITY >", value, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("APPLY_QUANTITY >=", value, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityLessThan(BigDecimal value) {
            addCriterion("APPLY_QUANTITY <", value, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("APPLY_QUANTITY <=", value, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityIn(List<BigDecimal> values) {
            addCriterion("APPLY_QUANTITY in", values, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityNotIn(List<BigDecimal> values) {
            addCriterion("APPLY_QUANTITY not in", values, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("APPLY_QUANTITY between", value1, value2, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andApplyQuantityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("APPLY_QUANTITY not between", value1, value2, "applyQuantity");
            return (Criteria) this;
        }

        public Criteria andBasicUnitIsNull() {
            addCriterion("BASIC_UNIT is null");
            return (Criteria) this;
        }

        public Criteria andBasicUnitIsNotNull() {
            addCriterion("BASIC_UNIT is not null");
            return (Criteria) this;
        }

        public Criteria andBasicUnitEqualTo(String value) {
            addCriterion("BASIC_UNIT =", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitNotEqualTo(String value) {
            addCriterion("BASIC_UNIT <>", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitGreaterThan(String value) {
            addCriterion("BASIC_UNIT >", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitGreaterThanOrEqualTo(String value) {
            addCriterion("BASIC_UNIT >=", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitLessThan(String value) {
            addCriterion("BASIC_UNIT <", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitLessThanOrEqualTo(String value) {
            addCriterion("BASIC_UNIT <=", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitLike(String value) {
            addCriterion("BASIC_UNIT like", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitNotLike(String value) {
            addCriterion("BASIC_UNIT not like", value, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitIn(List<String> values) {
            addCriterion("BASIC_UNIT in", values, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitNotIn(List<String> values) {
            addCriterion("BASIC_UNIT not in", values, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitBetween(String value1, String value2) {
            addCriterion("BASIC_UNIT between", value1, value2, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andBasicUnitNotBetween(String value1, String value2) {
            addCriterion("BASIC_UNIT not between", value1, value2, "basicUnit");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityIsNull() {
            addCriterion("PURCHASE_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityIsNotNull() {
            addCriterion("PURCHASE_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_QUANTITY =", value, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityNotEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_QUANTITY <>", value, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityGreaterThan(BigDecimal value) {
            addCriterion("PURCHASE_QUANTITY >", value, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_QUANTITY >=", value, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityLessThan(BigDecimal value) {
            addCriterion("PURCHASE_QUANTITY <", value, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("PURCHASE_QUANTITY <=", value, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityIn(List<BigDecimal> values) {
            addCriterion("PURCHASE_QUANTITY in", values, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityNotIn(List<BigDecimal> values) {
            addCriterion("PURCHASE_QUANTITY not in", values, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PURCHASE_QUANTITY between", value1, value2, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andPurchaseQuantityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PURCHASE_QUANTITY not between", value1, value2, "purchaseQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityIsNull() {
            addCriterion("ORDERED_QUANTITY is null");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityIsNotNull() {
            addCriterion("ORDERED_QUANTITY is not null");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityEqualTo(BigDecimal value) {
            addCriterion("ORDERED_QUANTITY =", value, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityNotEqualTo(BigDecimal value) {
            addCriterion("ORDERED_QUANTITY <>", value, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityGreaterThan(BigDecimal value) {
            addCriterion("ORDERED_QUANTITY >", value, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("ORDERED_QUANTITY >=", value, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityLessThan(BigDecimal value) {
            addCriterion("ORDERED_QUANTITY <", value, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("ORDERED_QUANTITY <=", value, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityIn(List<BigDecimal> values) {
            addCriterion("ORDERED_QUANTITY in", values, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityNotIn(List<BigDecimal> values) {
            addCriterion("ORDERED_QUANTITY not in", values, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("ORDERED_QUANTITY between", value1, value2, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andOrderedQuantityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("ORDERED_QUANTITY not between", value1, value2, "orderedQuantity");
            return (Criteria) this;
        }

        public Criteria andUnIsNull() {
            addCriterion("UN is null");
            return (Criteria) this;
        }

        public Criteria andUnIsNotNull() {
            addCriterion("UN is not null");
            return (Criteria) this;
        }

        public Criteria andUnEqualTo(String value) {
            addCriterion("UN =", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnNotEqualTo(String value) {
            addCriterion("UN <>", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnGreaterThan(String value) {
            addCriterion("UN >", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnGreaterThanOrEqualTo(String value) {
            addCriterion("UN >=", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnLessThan(String value) {
            addCriterion("UN <", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnLessThanOrEqualTo(String value) {
            addCriterion("UN <=", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnLike(String value) {
            addCriterion("UN like", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnNotLike(String value) {
            addCriterion("UN not like", value, "un");
            return (Criteria) this;
        }

        public Criteria andUnIn(List<String> values) {
            addCriterion("UN in", values, "un");
            return (Criteria) this;
        }

        public Criteria andUnNotIn(List<String> values) {
            addCriterion("UN not in", values, "un");
            return (Criteria) this;
        }

        public Criteria andUnBetween(String value1, String value2) {
            addCriterion("UN between", value1, value2, "un");
            return (Criteria) this;
        }

        public Criteria andUnNotBetween(String value1, String value2) {
            addCriterion("UN not between", value1, value2, "un");
            return (Criteria) this;
        }

        public Criteria andSIsNull() {
            addCriterion("S is null");
            return (Criteria) this;
        }

        public Criteria andSIsNotNull() {
            addCriterion("S is not null");
            return (Criteria) this;
        }

        public Criteria andSEqualTo(String value) {
            addCriterion("S =", value, "s");
            return (Criteria) this;
        }

        public Criteria andSNotEqualTo(String value) {
            addCriterion("S <>", value, "s");
            return (Criteria) this;
        }

        public Criteria andSGreaterThan(String value) {
            addCriterion("S >", value, "s");
            return (Criteria) this;
        }

        public Criteria andSGreaterThanOrEqualTo(String value) {
            addCriterion("S >=", value, "s");
            return (Criteria) this;
        }

        public Criteria andSLessThan(String value) {
            addCriterion("S <", value, "s");
            return (Criteria) this;
        }

        public Criteria andSLessThanOrEqualTo(String value) {
            addCriterion("S <=", value, "s");
            return (Criteria) this;
        }

        public Criteria andSLike(String value) {
            addCriterion("S like", value, "s");
            return (Criteria) this;
        }

        public Criteria andSNotLike(String value) {
            addCriterion("S not like", value, "s");
            return (Criteria) this;
        }

        public Criteria andSIn(List<String> values) {
            addCriterion("S in", values, "s");
            return (Criteria) this;
        }

        public Criteria andSNotIn(List<String> values) {
            addCriterion("S not in", values, "s");
            return (Criteria) this;
        }

        public Criteria andSBetween(String value1, String value2) {
            addCriterion("S between", value1, value2, "s");
            return (Criteria) this;
        }

        public Criteria andSNotBetween(String value1, String value2) {
            addCriterion("S not between", value1, value2, "s");
            return (Criteria) this;
        }

        public Criteria andCategoryIsNull() {
            addCriterion("CATEGORY is null");
            return (Criteria) this;
        }

        public Criteria andCategoryIsNotNull() {
            addCriterion("CATEGORY is not null");
            return (Criteria) this;
        }

        public Criteria andCategoryEqualTo(String value) {
            addCriterion("CATEGORY =", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryNotEqualTo(String value) {
            addCriterion("CATEGORY <>", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryGreaterThan(String value) {
            addCriterion("CATEGORY >", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryGreaterThanOrEqualTo(String value) {
            addCriterion("CATEGORY >=", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryLessThan(String value) {
            addCriterion("CATEGORY <", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryLessThanOrEqualTo(String value) {
            addCriterion("CATEGORY <=", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryLike(String value) {
            addCriterion("CATEGORY like", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryNotLike(String value) {
            addCriterion("CATEGORY not like", value, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryIn(List<String> values) {
            addCriterion("CATEGORY in", values, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryNotIn(List<String> values) {
            addCriterion("CATEGORY not in", values, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryBetween(String value1, String value2) {
            addCriterion("CATEGORY between", value1, value2, "category");
            return (Criteria) this;
        }

        public Criteria andCategoryNotBetween(String value1, String value2) {
            addCriterion("CATEGORY not between", value1, value2, "category");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeIsNull() {
            addCriterion("VOUCHER_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeIsNotNull() {
            addCriterion("VOUCHER_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeEqualTo(String value) {
            addCriterion("VOUCHER_TYPE =", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeNotEqualTo(String value) {
            addCriterion("VOUCHER_TYPE <>", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeGreaterThan(String value) {
            addCriterion("VOUCHER_TYPE >", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeGreaterThanOrEqualTo(String value) {
            addCriterion("VOUCHER_TYPE >=", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeLessThan(String value) {
            addCriterion("VOUCHER_TYPE <", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeLessThanOrEqualTo(String value) {
            addCriterion("VOUCHER_TYPE <=", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeLike(String value) {
            addCriterion("VOUCHER_TYPE like", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeNotLike(String value) {
            addCriterion("VOUCHER_TYPE not like", value, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeIn(List<String> values) {
            addCriterion("VOUCHER_TYPE in", values, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeNotIn(List<String> values) {
            addCriterion("VOUCHER_TYPE not in", values, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeBetween(String value1, String value2) {
            addCriterion("VOUCHER_TYPE between", value1, value2, "voucherType");
            return (Criteria) this;
        }

        public Criteria andVoucherTypeNotBetween(String value1, String value2) {
            addCriterion("VOUCHER_TYPE not between", value1, value2, "voucherType");
            return (Criteria) this;
        }

        public Criteria andDemandDateIsNull() {
            addCriterion("DEMAND_DATE is null");
            return (Criteria) this;
        }

        public Criteria andDemandDateIsNotNull() {
            addCriterion("DEMAND_DATE is not null");
            return (Criteria) this;
        }

        public Criteria andDemandDateEqualTo(Date value) {
            addCriterionForJDBCDate("DEMAND_DATE =", value, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateNotEqualTo(Date value) {
            addCriterionForJDBCDate("DEMAND_DATE <>", value, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateGreaterThan(Date value) {
            addCriterionForJDBCDate("DEMAND_DATE >", value, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("DEMAND_DATE >=", value, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateLessThan(Date value) {
            addCriterionForJDBCDate("DEMAND_DATE <", value, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("DEMAND_DATE <=", value, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateIn(List<Date> values) {
            addCriterionForJDBCDate("DEMAND_DATE in", values, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateNotIn(List<Date> values) {
            addCriterionForJDBCDate("DEMAND_DATE not in", values, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("DEMAND_DATE between", value1, value2, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDemandDateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("DEMAND_DATE not between", value1, value2, "demandDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateIsNull() {
            addCriterion("DELIVERY_DATE is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateIsNotNull() {
            addCriterion("DELIVERY_DATE is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateEqualTo(Date value) {
            addCriterionForJDBCDate("DELIVERY_DATE =", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateNotEqualTo(Date value) {
            addCriterionForJDBCDate("DELIVERY_DATE <>", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateGreaterThan(Date value) {
            addCriterionForJDBCDate("DELIVERY_DATE >", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("DELIVERY_DATE >=", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateLessThan(Date value) {
            addCriterionForJDBCDate("DELIVERY_DATE <", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("DELIVERY_DATE <=", value, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateIn(List<Date> values) {
            addCriterionForJDBCDate("DELIVERY_DATE in", values, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateNotIn(List<Date> values) {
            addCriterionForJDBCDate("DELIVERY_DATE not in", values, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("DELIVERY_DATE between", value1, value2, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andDeliveryDateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("DELIVERY_DATE not between", value1, value2, "deliveryDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateIsNull() {
            addCriterion("APPROVE_DATE is null");
            return (Criteria) this;
        }

        public Criteria andApproveDateIsNotNull() {
            addCriterion("APPROVE_DATE is not null");
            return (Criteria) this;
        }

        public Criteria andApproveDateEqualTo(Date value) {
            addCriterionForJDBCDate("APPROVE_DATE =", value, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateNotEqualTo(Date value) {
            addCriterionForJDBCDate("APPROVE_DATE <>", value, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateGreaterThan(Date value) {
            addCriterionForJDBCDate("APPROVE_DATE >", value, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("APPROVE_DATE >=", value, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateLessThan(Date value) {
            addCriterionForJDBCDate("APPROVE_DATE <", value, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("APPROVE_DATE <=", value, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateIn(List<Date> values) {
            addCriterionForJDBCDate("APPROVE_DATE in", values, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateNotIn(List<Date> values) {
            addCriterionForJDBCDate("APPROVE_DATE not in", values, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("APPROVE_DATE between", value1, value2, "approveDate");
            return (Criteria) this;
        }

        public Criteria andApproveDateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("APPROVE_DATE not between", value1, value2, "approveDate");
            return (Criteria) this;
        }

        public Criteria andCreatorIsNull() {
            addCriterion("CREATOR is null");
            return (Criteria) this;
        }

        public Criteria andCreatorIsNotNull() {
            addCriterion("CREATOR is not null");
            return (Criteria) this;
        }

        public Criteria andCreatorEqualTo(String value) {
            addCriterion("CREATOR =", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorNotEqualTo(String value) {
            addCriterion("CREATOR <>", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorGreaterThan(String value) {
            addCriterion("CREATOR >", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorGreaterThanOrEqualTo(String value) {
            addCriterion("CREATOR >=", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorLessThan(String value) {
            addCriterion("CREATOR <", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorLessThanOrEqualTo(String value) {
            addCriterion("CREATOR <=", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorLike(String value) {
            addCriterion("CREATOR like", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorNotLike(String value) {
            addCriterion("CREATOR not like", value, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorIn(List<String> values) {
            addCriterion("CREATOR in", values, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorNotIn(List<String> values) {
            addCriterion("CREATOR not in", values, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorBetween(String value1, String value2) {
            addCriterion("CREATOR between", value1, value2, "creator");
            return (Criteria) this;
        }

        public Criteria andCreatorNotBetween(String value1, String value2) {
            addCriterion("CREATOR not between", value1, value2, "creator");
            return (Criteria) this;
        }

        public Criteria andDemanderIsNull() {
            addCriterion("DEMANDER is null");
            return (Criteria) this;
        }

        public Criteria andDemanderIsNotNull() {
            addCriterion("DEMANDER is not null");
            return (Criteria) this;
        }

        public Criteria andDemanderEqualTo(String value) {
            addCriterion("DEMANDER =", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderNotEqualTo(String value) {
            addCriterion("DEMANDER <>", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderGreaterThan(String value) {
            addCriterion("DEMANDER >", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderGreaterThanOrEqualTo(String value) {
            addCriterion("DEMANDER >=", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderLessThan(String value) {
            addCriterion("DEMANDER <", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderLessThanOrEqualTo(String value) {
            addCriterion("DEMANDER <=", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderLike(String value) {
            addCriterion("DEMANDER like", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderNotLike(String value) {
            addCriterion("DEMANDER not like", value, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderIn(List<String> values) {
            addCriterion("DEMANDER in", values, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderNotIn(List<String> values) {
            addCriterion("DEMANDER not in", values, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderBetween(String value1, String value2) {
            addCriterion("DEMANDER between", value1, value2, "demander");
            return (Criteria) this;
        }

        public Criteria andDemanderNotBetween(String value1, String value2) {
            addCriterion("DEMANDER not between", value1, value2, "demander");
            return (Criteria) this;
        }

        public Criteria andPgrIsNull() {
            addCriterion("PGR is null");
            return (Criteria) this;
        }

        public Criteria andPgrIsNotNull() {
            addCriterion("PGR is not null");
            return (Criteria) this;
        }

        public Criteria andPgrEqualTo(String value) {
            addCriterion("PGR =", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrNotEqualTo(String value) {
            addCriterion("PGR <>", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrGreaterThan(String value) {
            addCriterion("PGR >", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrGreaterThanOrEqualTo(String value) {
            addCriterion("PGR >=", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrLessThan(String value) {
            addCriterion("PGR <", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrLessThanOrEqualTo(String value) {
            addCriterion("PGR <=", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrLike(String value) {
            addCriterion("PGR like", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrNotLike(String value) {
            addCriterion("PGR not like", value, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrIn(List<String> values) {
            addCriterion("PGR in", values, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrNotIn(List<String> values) {
            addCriterion("PGR not in", values, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrBetween(String value1, String value2) {
            addCriterion("PGR between", value1, value2, "pgr");
            return (Criteria) this;
        }

        public Criteria andPgrNotBetween(String value1, String value2) {
            addCriterion("PGR not between", value1, value2, "pgr");
            return (Criteria) this;
        }

        public Criteria andTrackingNoIsNull() {
            addCriterion("TRACKING_NO is null");
            return (Criteria) this;
        }

        public Criteria andTrackingNoIsNotNull() {
            addCriterion("TRACKING_NO is not null");
            return (Criteria) this;
        }

        public Criteria andTrackingNoEqualTo(String value) {
            addCriterion("TRACKING_NO =", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoNotEqualTo(String value) {
            addCriterion("TRACKING_NO <>", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoGreaterThan(String value) {
            addCriterion("TRACKING_NO >", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoGreaterThanOrEqualTo(String value) {
            addCriterion("TRACKING_NO >=", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoLessThan(String value) {
            addCriterion("TRACKING_NO <", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoLessThanOrEqualTo(String value) {
            addCriterion("TRACKING_NO <=", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoLike(String value) {
            addCriterion("TRACKING_NO like", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoNotLike(String value) {
            addCriterion("TRACKING_NO not like", value, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoIn(List<String> values) {
            addCriterion("TRACKING_NO in", values, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoNotIn(List<String> values) {
            addCriterion("TRACKING_NO not in", values, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoBetween(String value1, String value2) {
            addCriterion("TRACKING_NO between", value1, value2, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andTrackingNoNotBetween(String value1, String value2) {
            addCriterion("TRACKING_NO not between", value1, value2, "trackingNo");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupIsNull() {
            addCriterion("MATERIAL_GROUP is null");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupIsNotNull() {
            addCriterion("MATERIAL_GROUP is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupEqualTo(String value) {
            addCriterion("MATERIAL_GROUP =", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupNotEqualTo(String value) {
            addCriterion("MATERIAL_GROUP <>", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupGreaterThan(String value) {
            addCriterion("MATERIAL_GROUP >", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_GROUP >=", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupLessThan(String value) {
            addCriterion("MATERIAL_GROUP <", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_GROUP <=", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupLike(String value) {
            addCriterion("MATERIAL_GROUP like", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupNotLike(String value) {
            addCriterion("MATERIAL_GROUP not like", value, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupIn(List<String> values) {
            addCriterion("MATERIAL_GROUP in", values, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupNotIn(List<String> values) {
            addCriterion("MATERIAL_GROUP not in", values, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupBetween(String value1, String value2) {
            addCriterion("MATERIAL_GROUP between", value1, value2, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andMaterialGroupNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_GROUP not between", value1, value2, "materialGroup");
            return (Criteria) this;
        }

        public Criteria andUpdateDateIsNull() {
            addCriterion("UPDATE_DATE is null");
            return (Criteria) this;
        }

        public Criteria andUpdateDateIsNotNull() {
            addCriterion("UPDATE_DATE is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateDateEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_DATE =", value, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateNotEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_DATE <>", value, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateGreaterThan(Date value) {
            addCriterionForJDBCDate("UPDATE_DATE >", value, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_DATE >=", value, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateLessThan(Date value) {
            addCriterionForJDBCDate("UPDATE_DATE <", value, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("UPDATE_DATE <=", value, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateIn(List<Date> values) {
            addCriterionForJDBCDate("UPDATE_DATE in", values, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateNotIn(List<Date> values) {
            addCriterionForJDBCDate("UPDATE_DATE not in", values, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("UPDATE_DATE between", value1, value2, "updateDate");
            return (Criteria) this;
        }

        public Criteria andUpdateDateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("UPDATE_DATE not between", value1, value2, "updateDate");
            return (Criteria) this;
        }

        public Criteria andApproveStatusIsNull() {
            addCriterion("APPROVE_STATUS is null");
            return (Criteria) this;
        }

        public Criteria andApproveStatusIsNotNull() {
            addCriterion("APPROVE_STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andApproveStatusEqualTo(String value) {
            addCriterion("APPROVE_STATUS =", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotEqualTo(String value) {
            addCriterion("APPROVE_STATUS <>", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusGreaterThan(String value) {
            addCriterion("APPROVE_STATUS >", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusGreaterThanOrEqualTo(String value) {
            addCriterion("APPROVE_STATUS >=", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusLessThan(String value) {
            addCriterion("APPROVE_STATUS <", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusLessThanOrEqualTo(String value) {
            addCriterion("APPROVE_STATUS <=", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusLike(String value) {
            addCriterion("APPROVE_STATUS like", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotLike(String value) {
            addCriterion("APPROVE_STATUS not like", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusIn(List<String> values) {
            addCriterion("APPROVE_STATUS in", values, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotIn(List<String> values) {
            addCriterion("APPROVE_STATUS not in", values, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusBetween(String value1, String value2) {
            addCriterion("APPROVE_STATUS between", value1, value2, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotBetween(String value1, String value2) {
            addCriterion("APPROVE_STATUS not between", value1, value2, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderIsNull() {
            addCriterion("IS_CREATE_INQUIRY_ORDER is null");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderIsNotNull() {
            addCriterion("IS_CREATE_INQUIRY_ORDER is not null");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderEqualTo(Integer value) {
            addCriterion("IS_CREATE_INQUIRY_ORDER =", value, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderNotEqualTo(Integer value) {
            addCriterion("IS_CREATE_INQUIRY_ORDER <>", value, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderGreaterThan(Integer value) {
            addCriterion("IS_CREATE_INQUIRY_ORDER >", value, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_CREATE_INQUIRY_ORDER >=", value, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderLessThan(Integer value) {
            addCriterion("IS_CREATE_INQUIRY_ORDER <", value, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderLessThanOrEqualTo(Integer value) {
            addCriterion("IS_CREATE_INQUIRY_ORDER <=", value, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderIn(List<Integer> values) {
            addCriterion("IS_CREATE_INQUIRY_ORDER in", values, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderNotIn(List<Integer> values) {
            addCriterion("IS_CREATE_INQUIRY_ORDER not in", values, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderBetween(Integer value1, Integer value2) {
            addCriterion("IS_CREATE_INQUIRY_ORDER between", value1, value2, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andIsCreateInquiryOrderNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_CREATE_INQUIRY_ORDER not between", value1, value2, "isCreateInquiryOrder");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoIsNull() {
            addCriterion("INQUIRY_ORDER_NO is null");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoIsNotNull() {
            addCriterion("INQUIRY_ORDER_NO is not null");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoEqualTo(String value) {
            addCriterion("INQUIRY_ORDER_NO =", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoNotEqualTo(String value) {
            addCriterion("INQUIRY_ORDER_NO <>", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoGreaterThan(String value) {
            addCriterion("INQUIRY_ORDER_NO >", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoGreaterThanOrEqualTo(String value) {
            addCriterion("INQUIRY_ORDER_NO >=", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoLessThan(String value) {
            addCriterion("INQUIRY_ORDER_NO <", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoLessThanOrEqualTo(String value) {
            addCriterion("INQUIRY_ORDER_NO <=", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoLike(String value) {
            addCriterion("INQUIRY_ORDER_NO like", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoNotLike(String value) {
            addCriterion("INQUIRY_ORDER_NO not like", value, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoIn(List<String> values) {
            addCriterion("INQUIRY_ORDER_NO in", values, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoNotIn(List<String> values) {
            addCriterion("INQUIRY_ORDER_NO not in", values, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoBetween(String value1, String value2) {
            addCriterion("INQUIRY_ORDER_NO between", value1, value2, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andInquiryOrderNoNotBetween(String value1, String value2) {
            addCriterion("INQUIRY_ORDER_NO not between", value1, value2, "inquiryOrderNo");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}