package com.els.base.inquiry.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="询报价-同类物料参考比价")
public class MaterielParity implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("行数据ID")
    private String orderItemId;

    @ApiModelProperty("供应商编码")
    private String companyCode;

    @ApiModelProperty("供应商SAP编码")
    private String companySapCode;

    @ApiModelProperty("供应商名称")
    private String companyName;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("规格描述")
    private String materialDesc;

    @ApiModelProperty("ERP系统价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("ERP系统价对比")
    private BigDecimal systemPriceComparison;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getOrderItemId() {
        return orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId == null ? null : orderItemId.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getCompanySapCode() {
        return companySapCode;
    }

    public void setCompanySapCode(String companySapCode) {
        this.companySapCode = companySapCode == null ? null : companySapCode.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public BigDecimal getSystemPriceComparison() {
        return systemPriceComparison;
    }

    public void setSystemPriceComparison(BigDecimal systemPriceComparison) {
        this.systemPriceComparison = systemPriceComparison;
    }
    
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }
}