package com.els.base.inquiry.entity;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-模具成本分析清单")
@JsonSerialize(using=DetailSerialzer.class)
public class MouldDetail implements IMouldDetail {
	

	/*------------------请勿覆盖-----------------------*/
	

	@Override
	public void build(IMould mould) {
		this.setMouldId(mould.getId());
		this.setSupCompanyId(mould.getSupCompanyId());
		this.setSupCompanyName(mould.getSupCompanyName());
		this.setSupCompanySapCode(mould.getSupCompanySapCode());
		this.setSupCompanySrmCode(mould.getSupCompanySrmCode());
		this.setPurOrderId(mould.getPurOrderId());
		this.setSupOrderId(mould.getSupOrderId());
	}
	
	@Override
	public List<PropertyDef> getPropertyDefList() {
		if (StringUtils.isNotBlank(this.getTemplateId())) {
			TplMouldDetail tplMouldDetail = SpringContextHolder.getOneBean(TplMouldDetailService.class).queryObjById(this.getTemplateId());
			return tplMouldDetail.getPropertyDefList();
			
		}else if(StringUtils.isNotBlank(this.getPurOrderId())){
			PurOrder purOrder = SpringContextHolder.getOneBean(PurOrderService.class).queryObjById(this.getPurOrderId());
			if (purOrder!=null && StringUtils.isNotBlank(purOrder.getTemplateId())) {
				TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(purOrder.getTemplateId());
				return templateConf.getTplMouLdDetail().getPropertyDefList();
			}
		}
		return PropertyDefUtils.getProperyDefByClass(this.getClass());
	}
	
	private List<PropertyValue> propertyValueList;
	
	@Override
	public List<PropertyValue> getPropertyValueList() {
		return this.propertyValueList;
	}
	
	@Override
	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}
	
	/*-----------------------------------------*/
	
	
    @ApiModelProperty(hidden=true,value="主键")
    private String id;

    @ApiModelProperty(hidden=true,value="询价单头id")
    private String purOrderId;

    @ApiModelProperty(hidden=true,value="供应商询价单头ID")
    private String supOrderId;

    @ApiModelProperty("供应商编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty(hidden=true, value="创建时间")
    private Date createTime;

    @ApiModelProperty(hidden=true, value="更新时间")
    private Date updateTime;

    @ApiModelProperty(hidden=true, value="记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty(hidden=true, value="排序号")
    private Integer sortNo;

    @ApiModelProperty(hidden=true, value="模板id")
    private String templateId;

    @ApiModelProperty(hidden=true, value="模具清单id")
    private String mouldId;

    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;

    @ApiModelProperty(hidden=true, value="供应商id")
    private String supCompanyId;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getSupOrderId() {
        return supOrderId;
    }

    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getMouldId() {
        return mouldId;
    }

    public void setMouldId(String mouldId) {
        this.mouldId = mouldId == null ? null : mouldId.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

}