package com.els.base.inquiry.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractOrderItem;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.inquiry.utils.json.OrderItemJsonDeSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=OrderItemJsonDeSerialzer.class)
@ApiModel(value="询报价-行数据-M001")
public class OrderItemM001 extends AbstractOrderItem {

	/*---------一下非自动生成，请勿覆盖------------*/
	
	@Override
	public void isVaildForQuote() {
		Assert.isNotNull(this.getUntaxedUnitPrice(), "不含税单价不能为空");
	}
	@Override
	public IOrderItem build(PurOrder order, InquirySupOrder supOrder, ITarget target) {
		org.springframework.beans.BeanUtils.copyProperties(target, this);
		this.setId(UUIDGenerator.generateUUID());
		this.setPurOrderId(supOrder.getPurOrderId());//采购方询价单ID
		this.setSupOrderId(supOrder.getId());//供应商询价单ID
		this.setTemplateId(order.getTemplateId());//模板ID
		this.setOrderNo(order.getOrderNo());

		this.setOrderItemNo(target.getOrderItemNo());
		this.setTargetId(target.getId());
		this.setMaterialCode(target.getMaterialCode());//物料编码
		this.setQuoteType(target.getQuoteType());//报价类型，是否阶梯报价，默认跟采购方要求一致
		this.setSortNo(target.getSortNo());//供应商单行号
		this.setWaitMaterialId(target.getWaitMaterialId());
		this.setMapNo(target.getMapNo());// 图号
		this.setName(target.getName());// 名称
		this.setQuantity(target.getQuantity());// 数量
		this.setRecentUntaxedUnitPrice(target.getRecentUntaxedUnitPrice());// 最近一次采购不含税单价
		this.setDecreasingAmplitude(target.getDecreasingAmplitude());// 降幅
		this.setPurchaseGroup(target.getPurchaseGroup());// 采购组
		this.setPurOrderQuantity(target.getPurOrderQuantity());// 标准采购订单数量
		this.setMinOrderQuantity(target.getMinOrderQuantity());// 最小订单数量
		this.setPriceUnit(target.getPriceUnit());// 价格单位
		this.setValidDateFrom(target.getValidDateFrom());// 有效期从
		this.setValidDateTo(target.getValidDateTo());// 有效期到

		this.setSupCompanyId(supOrder.getSupCompanyId());
		this.setSupCompanyName(supOrder.getSupCompanyName());
		this.setSupCompanySapCode(supOrder.getSupCompanySapCode());
		this.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());

		this.setCreateTime(new Date());
		this.setUnableToQuote(Constant.NO_INT);
		this.setQuotationStatus(InquiryQuoteStatus.UNQUOTED.getCode());

		if (CollectionUtils.isEmpty(target.getPropertyValueList())) {
			return this;
		}

		List<PropertyValue> propertyValueList = target.getPropertyValueList().stream().map(propertyValue->{
			PropertyValue temp = new PropertyValue();
			BeanUtils.copyProperties(propertyValue, temp);
			temp.setId(null);
			return temp;
		}).collect(Collectors.toList());

		this.setPropertyValueList(propertyValueList);
		return this;
	}

	private List<PropertyValue> propertyValueList;

	@Override
	public List<PropertyValue> getPropertyValueList() {
		return this.propertyValueList;
	}

	@Override
	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}

	@Override
	public List<PropertyDef> getPropertyDefList() {
		if (StringUtils.isNotBlank(this.getTemplateId())) {
			TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(this.getTemplateId());
			return templateConf.getOrderItemPropertyDefList();

		}else if(StringUtils.isNotBlank(this.getPurOrderId())){
			PurOrder purOrder = SpringContextHolder.getOneBean(PurOrderService.class).queryObjById(this.getPurOrderId());
			if (purOrder!=null && StringUtils.isNotBlank(purOrder.getTemplateId())) {
				TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(purOrder.getTemplateId());
				return templateConf.getOrderItemPropertyDefList();
			}
		}
		return PropertyDefUtils.getProperyDefByClass(this.getClass());
	}

    @ApiModelProperty(hidden=true, value="参照物料对比",dataType="button")
 	private List<MaterielParity> materielParitys;

	public List<MaterielParity> getMaterielParitys() {
		return materielParitys;
	}

	public void setMaterielParitys(List<MaterielParity> materielParitys) {
		this.materielParitys = materielParitys;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class<? extends IOrderItemService> getOrderItemService() {
		return OrderItemM001Service.class;
	}
	
	/**由于当前数据不多，通过表关联的方式查询出来**/
	@ApiModelProperty(hidden=true, name="模板名称")
	private String templateName;
	
	@ApiModelProperty("审批状态，1未审批，2审批中，3审批通过，4审批驳回")
    private Integer auditStatus;
	
	public String getTemplateName() {
		return templateName;
	}
	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}
	public Integer getAuditStatus() {
		return auditStatus;
	}
	public void setAuditStatus(Integer auditStatus) {
		this.auditStatus = auditStatus;
	}

	/*--------end-------------*/

    @ApiModelProperty(hidden=true, name="主键")
    private String id;

    @ApiModelProperty(hidden=true, name="采购方表头id")
    private String purOrderId;

    @ApiModelProperty(hidden=true, name="供应方表头id")
    private String supOrderId;

    @ApiModelProperty(hidden=true, name="询价单号")
    private String orderNo;

    @ApiModelProperty(hidden=true, name="询价单行号(采购方)")
    private Integer orderItemNo;

    @ApiModelProperty(position=6, name="物料编码")
    private String materialCode;

    @ApiModelProperty(hidden=true, name="排序号(供应商行号)")
    private Integer sortNo;

    @ApiModelProperty(position=17, name="不含税单价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty(hidden=true, value="操作(接受/拒绝)", dataType="button")
    private Integer operation;

    @ApiModelProperty("报价状态")
    private Integer quotationStatus;

    @ApiModelProperty(hidden=true, value="定价说明")
    private String pricingDescription;

    @ApiModelProperty(position=1, value="供应商编码")
    private String supCompanySrmCode;

    @ApiModelProperty(position=2, value="供应商名称")
    private String supCompanyName;

    @ApiModelProperty(position=3, value="申请日期")
    private Date offerTime;

    @ApiModelProperty(position=5, value="报价人")
    private String supUserName;

    @ApiModelProperty(value="无法报价",dataType="button")
    private Integer unableToQuote;

    @ApiModelProperty(hidden=true, value="创建时间")
    private Date createTime;

    @ApiModelProperty(hidden=true, value="更新时间")
    private Date updateTime;

    @ApiModelProperty(hidden=true, name="记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty(hidden=true, value="模板ID")
    private String templateId;

    @ApiModelProperty(hidden=true, value="待询价物料ID")
    private String waitMaterialId;

    @ApiModelProperty(value="报价方式", dataType="button", position=20)
    private Integer quoteType;

    @ApiModelProperty(hidden=true, value="报价人id")
    private String supUserId;

    @ApiModelProperty(position=14, value="完成时间")
    private Date finishTime;

    @ApiModelProperty(hidden=true, name="物料清单id")
    private String targetId;

    @ApiModelProperty(hidden=true, name="供应商id")
    private String supCompanyId;

    @ApiModelProperty(position=4, value="供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty(hidden=true)
    private Integer isOrderItemDetailEnable;

    @ApiModelProperty(hidden=true, name="模具编码")
    private String mouldCode;

    @ApiModelProperty(position=13, value="报价时间")
    private Date quoteTime;

    @ApiModelProperty(position=12, value="备注")
    private String remark;

    @ApiModelProperty(position=10, value="图号")
    private String mapNo;

    @ApiModelProperty(position=11, value="名称")
    private String name;

    @ApiModelProperty(position=13, value="数量")
    private Long quantity;

    @ApiModelProperty(position=14, value="最近一次采购不含税单价")
    private BigDecimal recentUntaxedUnitPrice;

    @ApiModelProperty(position=15, value="降幅%")
    private String decreasingAmplitude;

    @ApiModelProperty(position=16, value="含税单价")
    private BigDecimal taxedUnitPrice;

    @ApiModelProperty(position=18, value="参考零部件图号")
    private String referPartMapNo;

    @ApiModelProperty(position=19, value="参考零部件价格")
    private BigDecimal referPartPrice;

    @ApiModelProperty(position=7, value="信息类别", dataType="dic_group", notes="info_category")
    private String infoCategory;

    @ApiModelProperty(position=22, value="交货周期")
    private Integer planDeliveryDate;

    @ApiModelProperty(position=23, value="采购组", dataType="dic_group", notes="purchasing_group")
    private String purchaseGroup;

    @ApiModelProperty(position=24, value="标准采购订单数量")
    private BigDecimal purOrderQuantity;

    @ApiModelProperty(position=25, value="最小订单数量")
    private BigDecimal minOrderQuantity;

    @ApiModelProperty(position=26, value="价格单位（每多少个）")
    private Integer priceUnit;

    @ApiModelProperty(position=27, value="有效期从")
    private Date validDateFrom;

    @ApiModelProperty(position=28, value="有效期到")
    private Date validDateTo;

    @ApiModelProperty(position=8, value="采购申请")
    private String purchaseApply;

    @ApiModelProperty(position=9, value="行号")
    private String project;

    @ApiModelProperty(position=29, value = "价格变化原因", dataType="dic_group", notes="PRICE_CHANGE_REASONS")
    private String priceChangeCode;

    @ApiModelProperty(hidden=true, value = "价格变化原因描述")
    private String priceChangeReasons;

    @ApiModelProperty(position=30, value = "影响部门", dataType="dic_group", notes="AFFECT_DEPARTMENT_CODE")
    private String affectDepartmentCode;

    @ApiModelProperty(hidden=true, value = "影响部门编码表述")
    private String affectDepartmentDesc;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getSupOrderId() {
        return supOrderId;
    }

    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public Integer getOrderItemNo() {
        return orderItemNo;
    }

    public void setOrderItemNo(Integer orderItemNo) {
        this.orderItemNo = orderItemNo;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public Integer getOperation() {
        return operation;
    }

    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    public Integer getQuotationStatus() {
        return quotationStatus;
    }

    public void setQuotationStatus(Integer quotationStatus) {
        this.quotationStatus = quotationStatus;
    }

    public String getPricingDescription() {
        return pricingDescription;
    }

    public void setPricingDescription(String pricingDescription) {
        this.pricingDescription = pricingDescription == null ? null : pricingDescription.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public Date getOfferTime() {
        return offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Integer getUnableToQuote() {
        return unableToQuote;
    }

    public void setUnableToQuote(Integer unableToQuote) {
        this.unableToQuote = unableToQuote;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getWaitMaterialId() {
        return waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    public Integer getQuoteType() {
        return quoteType;
    }

    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId == null ? null : targetId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public Integer getIsOrderItemDetailEnable() {
        return isOrderItemDetailEnable;
    }

    public void setIsOrderItemDetailEnable(Integer isOrderItemDetailEnable) {
        this.isOrderItemDetailEnable = isOrderItemDetailEnable;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Long getQuantity() {
        return quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getRecentUntaxedUnitPrice() {
        return recentUntaxedUnitPrice;
    }

    public void setRecentUntaxedUnitPrice(BigDecimal recentUntaxedUnitPrice) {
        this.recentUntaxedUnitPrice = recentUntaxedUnitPrice;
    }

    public String getDecreasingAmplitude() {
        return decreasingAmplitude;
    }

    public void setDecreasingAmplitude(String decreasingAmplitude) {
        this.decreasingAmplitude = decreasingAmplitude == null ? null : decreasingAmplitude.trim();
    }

    public BigDecimal getTaxedUnitPrice() {
        return taxedUnitPrice;
    }

    public void setTaxedUnitPrice(BigDecimal taxedUnitPrice) {
        this.taxedUnitPrice = taxedUnitPrice;
    }

    public String getReferPartMapNo() {
        return referPartMapNo;
    }

    public void setReferPartMapNo(String referPartMapNo) {
        this.referPartMapNo = referPartMapNo == null ? null : referPartMapNo.trim();
    }

    public BigDecimal getReferPartPrice() {
        return referPartPrice;
    }

    public void setReferPartPrice(BigDecimal referPartPrice) {
        this.referPartPrice = referPartPrice;
    }

    public String getInfoCategory() {
        return infoCategory;
    }

    public void setInfoCategory(String infoCategory) {
        this.infoCategory = infoCategory == null ? null : infoCategory.trim();
    }

    public Integer getPlanDeliveryDate() {
        return planDeliveryDate;
    }

    public void setPlanDeliveryDate(Integer planDeliveryDate) {
        this.planDeliveryDate = planDeliveryDate;
    }

    public String getPurchaseGroup() {
        return purchaseGroup;
    }

    public void setPurchaseGroup(String purchaseGroup) {
        this.purchaseGroup = purchaseGroup == null ? null : purchaseGroup.trim();
    }

    public BigDecimal getPurOrderQuantity() {
        return purOrderQuantity;
    }

    public void setPurOrderQuantity(BigDecimal purOrderQuantity) {
        this.purOrderQuantity = purOrderQuantity;
    }

    public BigDecimal getMinOrderQuantity() {
        return minOrderQuantity;
    }

    public void setMinOrderQuantity(BigDecimal minOrderQuantity) {
        this.minOrderQuantity = minOrderQuantity;
    }

    public Integer getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(Integer priceUnit) {
        this.priceUnit = priceUnit;
    }

    public Date getValidDateFrom() {
        return validDateFrom;
    }

    public void setValidDateFrom(Date validDateFrom) {
        this.validDateFrom = validDateFrom;
    }

    public Date getValidDateTo() {
        return validDateTo;
    }

    public void setValidDateTo(Date validDateTo) {
        this.validDateTo = validDateTo;
    }

    public String getPurchaseApply() {
        return purchaseApply;
    }

    public void setPurchaseApply(String purchaseApply) {
        this.purchaseApply = purchaseApply == null ? null : purchaseApply.trim();
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public String getPriceChangeCode() {
        return priceChangeCode;
    }

    public void setPriceChangeCode(String priceChangeCode) {
        this.priceChangeCode = priceChangeCode == null ? null : priceChangeCode.trim();
    }

    public String getPriceChangeReasons() {
        return priceChangeReasons;
    }

    public void setPriceChangeReasons(String priceChangeReasons) {
        this.priceChangeReasons = priceChangeReasons == null ? null : priceChangeReasons.trim();
    }

    public String getAffectDepartmentCode() {
        return affectDepartmentCode;
    }

    public void setAffectDepartmentCode(String affectDepartmentCode) {
        this.affectDepartmentCode = affectDepartmentCode == null ? null : affectDepartmentCode.trim();
    }

    public String getAffectDepartmentDesc() {
        return affectDepartmentDesc;
    }

    public void setAffectDepartmentDesc(String affectDepartmentDesc) {
        this.affectDepartmentDesc = affectDepartmentDesc == null ? null : affectDepartmentDesc.trim();
    }
}