package com.els.base.inquiry.entity;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

import com.els.base.inquiry.utils.json.ReadWriteTypeDeSerializer;
import com.els.base.inquiry.utils.json.ReadWriteTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-字段定义")
public class PropertyDef implements Serializable {
	
	/*-----------以下代码，请勿覆盖------------*/
	public PropertyValue buildValue(){
		PropertyValue value = new PropertyValue();
		BeanUtils.copyProperties(this, value);
		value.setFieldDefId(this.getId());
		value.setId(null);
		return value;
	}
	
	/*-----------以下代码，请勿覆盖------------*/
	
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("字段编码")
    private String code;

    @ApiModelProperty("字段名称")
    private String name;

    @ApiModelProperty("字段类型:字符串:string,数字:number,布尔boolean,按钮button,下拉字段组dic_group")
    private String type;

    @ApiModelProperty("是否必填")
    private Integer isRequired;

    @ApiModelProperty("字段长度")
    private Integer length;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("模板id")
    private String tplId;

    @ApiModelProperty("模板类型，询价单模板:ORDER_ITEM_TYPE, 商务条件模板BUSI_TYPE, 模具清单类型MOULD_TYPE, 物料成本清单类型DETAIL_TYPE, 模具成本清单类型MOULD_DETAIL_TYPE, 物料清单TARGET_TYPE")
    private String tplType;

    @JsonSerialize(using=ReadWriteTypeSerializer.class)
    @JsonDeserialize(using=ReadWriteTypeDeSerializer.class)
    @ApiModelProperty("是否可写，采购方:PUR_TYPE,供应方:WRITE_SUP,双方:BOTH_TYPE")
    private String writeType;

    @JsonSerialize(using=ReadWriteTypeSerializer.class)
    @JsonDeserialize(using=ReadWriteTypeDeSerializer.class)
    @ApiModelProperty("是否可读：采购方:PUR_TYPE,供应方:SUP_TYPE,双方:BOTH_TYPE")
    private String readType;

    @ApiModelProperty("排序顺序")
    private Integer sortNo;

    @ApiModelProperty("是否原生的，非自定义的字段")
    private Integer isPrimitive;

    @ApiModelProperty("显示名称")
    private String displayName;

    @ApiModelProperty("字段组编码")
    private String dicGroupCode;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public Integer getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(Integer isRequired) {
        this.isRequired = isRequired;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getTplId() {
        return tplId;
    }

    public void setTplId(String tplId) {
        this.tplId = tplId == null ? null : tplId.trim();
    }

    public String getTplType() {
        return tplType;
    }

    public void setTplType(String tplType) {
        this.tplType = tplType == null ? null : tplType.trim();
    }

    public String getWriteType() {
        return writeType;
    }

    public void setWriteType(String writeType) {
        this.writeType = writeType == null ? null : writeType.trim();
    }

    public String getReadType() {
        return readType;
    }

    public void setReadType(String readType) {
        this.readType = readType == null ? null : readType.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public Integer getIsPrimitive() {
        return isPrimitive;
    }

    public void setIsPrimitive(Integer isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    public String getDisplayName() {
    	if (StringUtils.isBlank(displayName)) {
			return this.getName();
		}
    	
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName == null ? null : displayName.trim();
    }

    public String getDicGroupCode() {
        return dicGroupCode;
    }

    public void setDicGroupCode(String dicGroupCode) {
        this.dicGroupCode = dicGroupCode == null ? null : dicGroupCode.trim();
    }
}