package com.els.base.inquiry.entity;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.utils.json.ReadWriteTypeDeSerializer;
import com.els.base.inquiry.utils.json.ReadWriteTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-字段值")
public class PropertyValue implements Serializable {
	
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("字段编码")
    private String code;

    @ApiModelProperty("字段名称")
    private String name;

    @ApiModelProperty("字段类型:字符串:string,数字:number,布尔boolean,按钮button")
    private String type;

    @ApiModelProperty("是否必填")
    private Integer isRequired;

    @ApiModelProperty("字段长度")
    private Integer length;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("模板id")
    private String tplId;

    @ApiModelProperty("模板类型，询价单模板:INQUIRY_TYPE, 商务条件模板BUSI_TYPE,模具清单类型MOULD_TYPE,物料成本清单类型DETAIL_TYPE")
    private String tplType;

    @ApiModelProperty("自定义字段id")
    private String fieldDefId;

    @ApiModelProperty("关联数据id，可以是询价单行id、商务条件id、模具清单id")
    private String refId;

    @JsonSerialize(using=ReadWriteTypeSerializer.class)
    @JsonDeserialize(using=ReadWriteTypeDeSerializer.class)
    @ApiModelProperty("输入类型：采购方输入:WRITE_PUR,供应方输入:WRITE_SUP,双方都能输入:BOTH_TYPE")
    private String writeType;

    @JsonSerialize(using=ReadWriteTypeSerializer.class)
    @JsonDeserialize(using=ReadWriteTypeDeSerializer.class)
    @ApiModelProperty("输入类型：采购方输入:WRITE_PUR,供应方输入:WRITE_SUP,双方都能输入:BOTH_TYPE")
    private String readType;

    @ApiModelProperty("是否原生的，非自定义的字段")
    private Integer isPrimitive;

    @ApiModelProperty("字段的值")
    private String valueStr;

    @ApiModelProperty("排序顺序")
    private Integer sortNo;

    @ApiModelProperty("显示名称")
    private String displayName;

    @ApiModelProperty("字段组编码")
    private String dicGroupCode;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    public Integer getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(Integer isRequired) {
        this.isRequired = isRequired;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getTplId() {
        return tplId;
    }

    public void setTplId(String tplId) {
        this.tplId = tplId == null ? null : tplId.trim();
    }

    public String getTplType() {
        return tplType;
    }

    public void setTplType(String tplType) {
        this.tplType = tplType == null ? null : tplType.trim();
    }

    public String getFieldDefId() {
        return fieldDefId;
    }

    public void setFieldDefId(String fieldDefId) {
        this.fieldDefId = fieldDefId == null ? null : fieldDefId.trim();
    }

    public String getRefId() {
        return refId;
    }

    public void setRefId(String refId) {
        this.refId = refId == null ? null : refId.trim();
    }

    public String getWriteType() {
        return writeType;
    }

    public void setWriteType(String writeType) {
        this.writeType = writeType == null ? null : writeType.trim();
    }

    public String getReadType() {
        return readType;
    }

    public void setReadType(String readType) {
        this.readType = readType == null ? null : readType.trim();
    }

    public Integer getIsPrimitive() {
        return isPrimitive;
    }

    public void setIsPrimitive(Integer isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    public String getValueStr() {
        return valueStr;
    }

    public void setValueStr(String valueStr) {
        this.valueStr = valueStr == null ? null : valueStr.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getDisplayName() {
    	if (StringUtils.isBlank(displayName)) {
			return getName();
		}
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName == null ? null : displayName.trim();
    }

    public String getDicGroupCode() {
        return dicGroupCode;
    }

    public void setDicGroupCode(String dicGroupCode) {
        this.dicGroupCode = dicGroupCode == null ? null : dicGroupCode.trim();
    }
}