package com.els.base.inquiry.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-物料的ERP系统价")
public class SystemPrice implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("行数据ID")
    private String orderItemId;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("工厂代码")
    private String factoryCode;

    @ApiModelProperty("采购组织")
    private String purchaseOrganization;

    @ApiModelProperty("价格有效起始日期")
    private Date priceEffectiveStartTime;

    @ApiModelProperty("价格有效截止日期")
    private Date priceEffectiveEndTime;

    @ApiModelProperty("不含税价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("价格基数")
    private Integer priceBase;

    @ApiModelProperty("价格单位")
    private Integer priceUnit;

    @ApiModelProperty("币别")
    private String currency;

    @ApiModelProperty("等级数量")
    private Integer gradeNumber;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("信息记录类别")
    private String informationRecordCategory;

    @ApiModelProperty("采购信息记录号")
    private String purInformationRecordNumber;

    @ApiModelProperty("供应商SAP编码")
    private String companySapCode;

    @ApiModelProperty("供应商名称")
    private String companyName;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("供应商使用的物料编码")
    private String supMaterialCode;

    @ApiModelProperty("供应商物料组")
    private String supMaterialGroup;

    @ApiModelProperty("发货国家")
    private String country;

    @ApiModelProperty("地区")
    private String region;

    @ApiModelProperty("采购组")
    private String purchasingGroup;

    @ApiModelProperty("条件类型")
    private String conditionalType;

    @ApiModelProperty("订单价格单位(采购)")
    private String purPriceUnit;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getOrderItemId() {
        return orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId == null ? null : orderItemId.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode == null ? null : factoryCode.trim();
    }

    public String getPurchaseOrganization() {
        return purchaseOrganization;
    }

    public void setPurchaseOrganization(String purchaseOrganization) {
        this.purchaseOrganization = purchaseOrganization == null ? null : purchaseOrganization.trim();
    }

    public Date getPriceEffectiveStartTime() {
        return priceEffectiveStartTime;
    }

    public void setPriceEffectiveStartTime(Date priceEffectiveStartTime) {
        this.priceEffectiveStartTime = priceEffectiveStartTime;
    }

    public Date getPriceEffectiveEndTime() {
        return priceEffectiveEndTime;
    }

    public void setPriceEffectiveEndTime(Date priceEffectiveEndTime) {
        this.priceEffectiveEndTime = priceEffectiveEndTime;
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public Integer getPriceBase() {
        return priceBase;
    }

    public void setPriceBase(Integer priceBase) {
        this.priceBase = priceBase;
    }

    public Integer getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(Integer priceUnit) {
        this.priceUnit = priceUnit;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public Integer getGradeNumber() {
        return gradeNumber;
    }

    public void setGradeNumber(Integer gradeNumber) {
        this.gradeNumber = gradeNumber;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getInformationRecordCategory() {
        return informationRecordCategory;
    }

    public void setInformationRecordCategory(String informationRecordCategory) {
        this.informationRecordCategory = informationRecordCategory == null ? null : informationRecordCategory.trim();
    }

    public String getPurInformationRecordNumber() {
        return purInformationRecordNumber;
    }

    public void setPurInformationRecordNumber(String purInformationRecordNumber) {
        this.purInformationRecordNumber = purInformationRecordNumber == null ? null : purInformationRecordNumber.trim();
    }

    public String getCompanySapCode() {
        return companySapCode;
    }

    public void setCompanySapCode(String companySapCode) {
        this.companySapCode = companySapCode == null ? null : companySapCode.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getSupMaterialCode() {
        return supMaterialCode;
    }

    public void setSupMaterialCode(String supMaterialCode) {
        this.supMaterialCode = supMaterialCode == null ? null : supMaterialCode.trim();
    }

    public String getSupMaterialGroup() {
        return supMaterialGroup;
    }

    public void setSupMaterialGroup(String supMaterialGroup) {
        this.supMaterialGroup = supMaterialGroup == null ? null : supMaterialGroup.trim();
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country == null ? null : country.trim();
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region == null ? null : region.trim();
    }

    public String getPurchasingGroup() {
        return purchasingGroup;
    }

    public void setPurchasingGroup(String purchasingGroup) {
        this.purchasingGroup = purchasingGroup == null ? null : purchasingGroup.trim();
    }

    public String getConditionalType() {
        return conditionalType;
    }

    public void setConditionalType(String conditionalType) {
        this.conditionalType = conditionalType == null ? null : conditionalType.trim();
    }

    public String getPurPriceUnit() {
        return purPriceUnit;
    }

    public void setPurPriceUnit(String purPriceUnit) {
        this.purPriceUnit = purPriceUnit == null ? null : purPriceUnit.trim();
    }
}