package com.els.base.inquiry.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SystemPriceExample extends AbstractExample<SystemPrice> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<SystemPrice> pageView = new PageView<SystemPrice>(1, 10);

    private static final long serialVersionUID = 1L;

    public SystemPriceExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<SystemPrice> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<SystemPrice> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdIsNull() {
            addCriterion("ORDER_ITEM_ID is null");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdIsNotNull() {
            addCriterion("ORDER_ITEM_ID is not null");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdEqualTo(String value) {
            addCriterion("ORDER_ITEM_ID =", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdNotEqualTo(String value) {
            addCriterion("ORDER_ITEM_ID <>", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdGreaterThan(String value) {
            addCriterion("ORDER_ITEM_ID >", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdGreaterThanOrEqualTo(String value) {
            addCriterion("ORDER_ITEM_ID >=", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdLessThan(String value) {
            addCriterion("ORDER_ITEM_ID <", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdLessThanOrEqualTo(String value) {
            addCriterion("ORDER_ITEM_ID <=", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdLike(String value) {
            addCriterion("ORDER_ITEM_ID like", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdNotLike(String value) {
            addCriterion("ORDER_ITEM_ID not like", value, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdIn(List<String> values) {
            addCriterion("ORDER_ITEM_ID in", values, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdNotIn(List<String> values) {
            addCriterion("ORDER_ITEM_ID not in", values, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdBetween(String value1, String value2) {
            addCriterion("ORDER_ITEM_ID between", value1, value2, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andOrderItemIdNotBetween(String value1, String value2) {
            addCriterion("ORDER_ITEM_ID not between", value1, value2, "orderItemId");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeIsNull() {
            addCriterion("MATERIAL_CODE is null");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeIsNotNull() {
            addCriterion("MATERIAL_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeEqualTo(String value) {
            addCriterion("MATERIAL_CODE =", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotEqualTo(String value) {
            addCriterion("MATERIAL_CODE <>", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeGreaterThan(String value) {
            addCriterion("MATERIAL_CODE >", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_CODE >=", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeLessThan(String value) {
            addCriterion("MATERIAL_CODE <", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_CODE <=", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeLike(String value) {
            addCriterion("MATERIAL_CODE like", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotLike(String value) {
            addCriterion("MATERIAL_CODE not like", value, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeIn(List<String> values) {
            addCriterion("MATERIAL_CODE in", values, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotIn(List<String> values) {
            addCriterion("MATERIAL_CODE not in", values, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeBetween(String value1, String value2) {
            addCriterion("MATERIAL_CODE between", value1, value2, "materialCode");
            return (Criteria) this;
        }

        public Criteria andMaterialCodeNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_CODE not between", value1, value2, "materialCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIsNull() {
            addCriterion("COMPANY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIsNotNull() {
            addCriterion("COMPANY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeEqualTo(String value) {
            addCriterion("COMPANY_CODE =", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotEqualTo(String value) {
            addCriterion("COMPANY_CODE <>", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeGreaterThan(String value) {
            addCriterion("COMPANY_CODE >", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_CODE >=", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLessThan(String value) {
            addCriterion("COMPANY_CODE <", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_CODE <=", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLike(String value) {
            addCriterion("COMPANY_CODE like", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotLike(String value) {
            addCriterion("COMPANY_CODE not like", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIn(List<String> values) {
            addCriterion("COMPANY_CODE in", values, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotIn(List<String> values) {
            addCriterion("COMPANY_CODE not in", values, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeBetween(String value1, String value2) {
            addCriterion("COMPANY_CODE between", value1, value2, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_CODE not between", value1, value2, "companyCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeIsNull() {
            addCriterion("FACTORY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeIsNotNull() {
            addCriterion("FACTORY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeEqualTo(String value) {
            addCriterion("FACTORY_CODE =", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotEqualTo(String value) {
            addCriterion("FACTORY_CODE <>", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeGreaterThan(String value) {
            addCriterion("FACTORY_CODE >", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeGreaterThanOrEqualTo(String value) {
            addCriterion("FACTORY_CODE >=", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeLessThan(String value) {
            addCriterion("FACTORY_CODE <", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeLessThanOrEqualTo(String value) {
            addCriterion("FACTORY_CODE <=", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeLike(String value) {
            addCriterion("FACTORY_CODE like", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotLike(String value) {
            addCriterion("FACTORY_CODE not like", value, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeIn(List<String> values) {
            addCriterion("FACTORY_CODE in", values, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotIn(List<String> values) {
            addCriterion("FACTORY_CODE not in", values, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeBetween(String value1, String value2) {
            addCriterion("FACTORY_CODE between", value1, value2, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andFactoryCodeNotBetween(String value1, String value2) {
            addCriterion("FACTORY_CODE not between", value1, value2, "factoryCode");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationIsNull() {
            addCriterion("PURCHASE_ORGANIZATION is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationIsNotNull() {
            addCriterion("PURCHASE_ORGANIZATION is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationEqualTo(String value) {
            addCriterion("PURCHASE_ORGANIZATION =", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationNotEqualTo(String value) {
            addCriterion("PURCHASE_ORGANIZATION <>", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationGreaterThan(String value) {
            addCriterion("PURCHASE_ORGANIZATION >", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASE_ORGANIZATION >=", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationLessThan(String value) {
            addCriterion("PURCHASE_ORGANIZATION <", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationLessThanOrEqualTo(String value) {
            addCriterion("PURCHASE_ORGANIZATION <=", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationLike(String value) {
            addCriterion("PURCHASE_ORGANIZATION like", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationNotLike(String value) {
            addCriterion("PURCHASE_ORGANIZATION not like", value, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationIn(List<String> values) {
            addCriterion("PURCHASE_ORGANIZATION in", values, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationNotIn(List<String> values) {
            addCriterion("PURCHASE_ORGANIZATION not in", values, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationBetween(String value1, String value2) {
            addCriterion("PURCHASE_ORGANIZATION between", value1, value2, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPurchaseOrganizationNotBetween(String value1, String value2) {
            addCriterion("PURCHASE_ORGANIZATION not between", value1, value2, "purchaseOrganization");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeIsNull() {
            addCriterion("PRICE_EFFECTIVE_START_TIME is null");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeIsNotNull() {
            addCriterion("PRICE_EFFECTIVE_START_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_START_TIME =", value, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeNotEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_START_TIME <>", value, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeGreaterThan(Date value) {
            addCriterion("PRICE_EFFECTIVE_START_TIME >", value, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_START_TIME >=", value, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeLessThan(Date value) {
            addCriterion("PRICE_EFFECTIVE_START_TIME <", value, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeLessThanOrEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_START_TIME <=", value, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeIn(List<Date> values) {
            addCriterion("PRICE_EFFECTIVE_START_TIME in", values, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeNotIn(List<Date> values) {
            addCriterion("PRICE_EFFECTIVE_START_TIME not in", values, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeBetween(Date value1, Date value2) {
            addCriterion("PRICE_EFFECTIVE_START_TIME between", value1, value2, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveStartTimeNotBetween(Date value1, Date value2) {
            addCriterion("PRICE_EFFECTIVE_START_TIME not between", value1, value2, "priceEffectiveStartTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeIsNull() {
            addCriterion("PRICE_EFFECTIVE_END_TIME is null");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeIsNotNull() {
            addCriterion("PRICE_EFFECTIVE_END_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_END_TIME =", value, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeNotEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_END_TIME <>", value, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeGreaterThan(Date value) {
            addCriterion("PRICE_EFFECTIVE_END_TIME >", value, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_END_TIME >=", value, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeLessThan(Date value) {
            addCriterion("PRICE_EFFECTIVE_END_TIME <", value, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeLessThanOrEqualTo(Date value) {
            addCriterion("PRICE_EFFECTIVE_END_TIME <=", value, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeIn(List<Date> values) {
            addCriterion("PRICE_EFFECTIVE_END_TIME in", values, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeNotIn(List<Date> values) {
            addCriterion("PRICE_EFFECTIVE_END_TIME not in", values, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeBetween(Date value1, Date value2) {
            addCriterion("PRICE_EFFECTIVE_END_TIME between", value1, value2, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andPriceEffectiveEndTimeNotBetween(Date value1, Date value2) {
            addCriterion("PRICE_EFFECTIVE_END_TIME not between", value1, value2, "priceEffectiveEndTime");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceIsNull() {
            addCriterion("UNTAXED_UNIT_PRICE is null");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceIsNotNull() {
            addCriterion("UNTAXED_UNIT_PRICE is not null");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceEqualTo(BigDecimal value) {
            addCriterion("UNTAXED_UNIT_PRICE =", value, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceNotEqualTo(BigDecimal value) {
            addCriterion("UNTAXED_UNIT_PRICE <>", value, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceGreaterThan(BigDecimal value) {
            addCriterion("UNTAXED_UNIT_PRICE >", value, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("UNTAXED_UNIT_PRICE >=", value, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceLessThan(BigDecimal value) {
            addCriterion("UNTAXED_UNIT_PRICE <", value, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceLessThanOrEqualTo(BigDecimal value) {
            addCriterion("UNTAXED_UNIT_PRICE <=", value, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceIn(List<BigDecimal> values) {
            addCriterion("UNTAXED_UNIT_PRICE in", values, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceNotIn(List<BigDecimal> values) {
            addCriterion("UNTAXED_UNIT_PRICE not in", values, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("UNTAXED_UNIT_PRICE between", value1, value2, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andUntaxedUnitPriceNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("UNTAXED_UNIT_PRICE not between", value1, value2, "untaxedUnitPrice");
            return (Criteria) this;
        }

        public Criteria andPriceBaseIsNull() {
            addCriterion("PRICE_BASE is null");
            return (Criteria) this;
        }

        public Criteria andPriceBaseIsNotNull() {
            addCriterion("PRICE_BASE is not null");
            return (Criteria) this;
        }

        public Criteria andPriceBaseEqualTo(Integer value) {
            addCriterion("PRICE_BASE =", value, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseNotEqualTo(Integer value) {
            addCriterion("PRICE_BASE <>", value, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseGreaterThan(Integer value) {
            addCriterion("PRICE_BASE >", value, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseGreaterThanOrEqualTo(Integer value) {
            addCriterion("PRICE_BASE >=", value, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseLessThan(Integer value) {
            addCriterion("PRICE_BASE <", value, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseLessThanOrEqualTo(Integer value) {
            addCriterion("PRICE_BASE <=", value, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseIn(List<Integer> values) {
            addCriterion("PRICE_BASE in", values, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseNotIn(List<Integer> values) {
            addCriterion("PRICE_BASE not in", values, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseBetween(Integer value1, Integer value2) {
            addCriterion("PRICE_BASE between", value1, value2, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceBaseNotBetween(Integer value1, Integer value2) {
            addCriterion("PRICE_BASE not between", value1, value2, "priceBase");
            return (Criteria) this;
        }

        public Criteria andPriceUnitIsNull() {
            addCriterion("PRICE_UNIT is null");
            return (Criteria) this;
        }

        public Criteria andPriceUnitIsNotNull() {
            addCriterion("PRICE_UNIT is not null");
            return (Criteria) this;
        }

        public Criteria andPriceUnitEqualTo(Integer value) {
            addCriterion("PRICE_UNIT =", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotEqualTo(Integer value) {
            addCriterion("PRICE_UNIT <>", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitGreaterThan(Integer value) {
            addCriterion("PRICE_UNIT >", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitGreaterThanOrEqualTo(Integer value) {
            addCriterion("PRICE_UNIT >=", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitLessThan(Integer value) {
            addCriterion("PRICE_UNIT <", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitLessThanOrEqualTo(Integer value) {
            addCriterion("PRICE_UNIT <=", value, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitIn(List<Integer> values) {
            addCriterion("PRICE_UNIT in", values, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotIn(List<Integer> values) {
            addCriterion("PRICE_UNIT not in", values, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitBetween(Integer value1, Integer value2) {
            addCriterion("PRICE_UNIT between", value1, value2, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andPriceUnitNotBetween(Integer value1, Integer value2) {
            addCriterion("PRICE_UNIT not between", value1, value2, "priceUnit");
            return (Criteria) this;
        }

        public Criteria andCurrencyIsNull() {
            addCriterion("CURRENCY is null");
            return (Criteria) this;
        }

        public Criteria andCurrencyIsNotNull() {
            addCriterion("CURRENCY is not null");
            return (Criteria) this;
        }

        public Criteria andCurrencyEqualTo(String value) {
            addCriterion("CURRENCY =", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotEqualTo(String value) {
            addCriterion("CURRENCY <>", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyGreaterThan(String value) {
            addCriterion("CURRENCY >", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyGreaterThanOrEqualTo(String value) {
            addCriterion("CURRENCY >=", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLessThan(String value) {
            addCriterion("CURRENCY <", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLessThanOrEqualTo(String value) {
            addCriterion("CURRENCY <=", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLike(String value) {
            addCriterion("CURRENCY like", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotLike(String value) {
            addCriterion("CURRENCY not like", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyIn(List<String> values) {
            addCriterion("CURRENCY in", values, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotIn(List<String> values) {
            addCriterion("CURRENCY not in", values, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyBetween(String value1, String value2) {
            addCriterion("CURRENCY between", value1, value2, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotBetween(String value1, String value2) {
            addCriterion("CURRENCY not between", value1, value2, "currency");
            return (Criteria) this;
        }

        public Criteria andGradeNumberIsNull() {
            addCriterion("GRADE_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andGradeNumberIsNotNull() {
            addCriterion("GRADE_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andGradeNumberEqualTo(Integer value) {
            addCriterion("GRADE_NUMBER =", value, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberNotEqualTo(Integer value) {
            addCriterion("GRADE_NUMBER <>", value, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberGreaterThan(Integer value) {
            addCriterion("GRADE_NUMBER >", value, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("GRADE_NUMBER >=", value, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberLessThan(Integer value) {
            addCriterion("GRADE_NUMBER <", value, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberLessThanOrEqualTo(Integer value) {
            addCriterion("GRADE_NUMBER <=", value, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberIn(List<Integer> values) {
            addCriterion("GRADE_NUMBER in", values, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberNotIn(List<Integer> values) {
            addCriterion("GRADE_NUMBER not in", values, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberBetween(Integer value1, Integer value2) {
            addCriterion("GRADE_NUMBER between", value1, value2, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andGradeNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("GRADE_NUMBER not between", value1, value2, "gradeNumber");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryIsNull() {
            addCriterion("INFORMATION_RECORD_CATEGORY is null");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryIsNotNull() {
            addCriterion("INFORMATION_RECORD_CATEGORY is not null");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryEqualTo(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY =", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryNotEqualTo(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY <>", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryGreaterThan(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY >", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryGreaterThanOrEqualTo(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY >=", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryLessThan(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY <", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryLessThanOrEqualTo(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY <=", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryLike(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY like", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryNotLike(String value) {
            addCriterion("INFORMATION_RECORD_CATEGORY not like", value, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryIn(List<String> values) {
            addCriterion("INFORMATION_RECORD_CATEGORY in", values, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryNotIn(List<String> values) {
            addCriterion("INFORMATION_RECORD_CATEGORY not in", values, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryBetween(String value1, String value2) {
            addCriterion("INFORMATION_RECORD_CATEGORY between", value1, value2, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andInformationRecordCategoryNotBetween(String value1, String value2) {
            addCriterion("INFORMATION_RECORD_CATEGORY not between", value1, value2, "informationRecordCategory");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberIsNull() {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberIsNotNull() {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberEqualTo(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER =", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberNotEqualTo(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER <>", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberGreaterThan(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER >", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER >=", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberLessThan(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER <", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberLessThanOrEqualTo(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER <=", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberLike(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER like", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberNotLike(String value) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER not like", value, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberIn(List<String> values) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER in", values, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberNotIn(List<String> values) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER not in", values, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberBetween(String value1, String value2) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER between", value1, value2, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andPurInformationRecordNumberNotBetween(String value1, String value2) {
            addCriterion("PUR_INFORMATION_RECORD_NUMBER not between", value1, value2, "purInformationRecordNumber");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeIsNull() {
            addCriterion("COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeIsNotNull() {
            addCriterion("COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE =", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE <>", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeGreaterThan(String value) {
            addCriterion("COMPANY_SAP_CODE >", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE >=", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeLessThan(String value) {
            addCriterion("COMPANY_SAP_CODE <", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE <=", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeLike(String value) {
            addCriterion("COMPANY_SAP_CODE like", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotLike(String value) {
            addCriterion("COMPANY_SAP_CODE not like", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeIn(List<String> values) {
            addCriterion("COMPANY_SAP_CODE in", values, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotIn(List<String> values) {
            addCriterion("COMPANY_SAP_CODE not in", values, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeBetween(String value1, String value2) {
            addCriterion("COMPANY_SAP_CODE between", value1, value2, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_SAP_CODE not between", value1, value2, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIsNull() {
            addCriterion("COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIsNotNull() {
            addCriterion("COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyNameEqualTo(String value) {
            addCriterion("COMPANY_NAME =", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotEqualTo(String value) {
            addCriterion("COMPANY_NAME <>", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameGreaterThan(String value) {
            addCriterion("COMPANY_NAME >", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_NAME >=", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLessThan(String value) {
            addCriterion("COMPANY_NAME <", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_NAME <=", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLike(String value) {
            addCriterion("COMPANY_NAME like", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotLike(String value) {
            addCriterion("COMPANY_NAME not like", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIn(List<String> values) {
            addCriterion("COMPANY_NAME in", values, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotIn(List<String> values) {
            addCriterion("COMPANY_NAME not in", values, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameBetween(String value1, String value2) {
            addCriterion("COMPANY_NAME between", value1, value2, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotBetween(String value1, String value2) {
            addCriterion("COMPANY_NAME not between", value1, value2, "companyName");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIsNull() {
            addCriterion("MATERIAL_DESC is null");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIsNotNull() {
            addCriterion("MATERIAL_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andMaterialDescEqualTo(String value) {
            addCriterion("MATERIAL_DESC =", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotEqualTo(String value) {
            addCriterion("MATERIAL_DESC <>", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescGreaterThan(String value) {
            addCriterion("MATERIAL_DESC >", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescGreaterThanOrEqualTo(String value) {
            addCriterion("MATERIAL_DESC >=", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLessThan(String value) {
            addCriterion("MATERIAL_DESC <", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLessThanOrEqualTo(String value) {
            addCriterion("MATERIAL_DESC <=", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescLike(String value) {
            addCriterion("MATERIAL_DESC like", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotLike(String value) {
            addCriterion("MATERIAL_DESC not like", value, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescIn(List<String> values) {
            addCriterion("MATERIAL_DESC in", values, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotIn(List<String> values) {
            addCriterion("MATERIAL_DESC not in", values, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescBetween(String value1, String value2) {
            addCriterion("MATERIAL_DESC between", value1, value2, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andMaterialDescNotBetween(String value1, String value2) {
            addCriterion("MATERIAL_DESC not between", value1, value2, "materialDesc");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeIsNull() {
            addCriterion("SUP_MATERIAL_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeIsNotNull() {
            addCriterion("SUP_MATERIAL_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeEqualTo(String value) {
            addCriterion("SUP_MATERIAL_CODE =", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeNotEqualTo(String value) {
            addCriterion("SUP_MATERIAL_CODE <>", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeGreaterThan(String value) {
            addCriterion("SUP_MATERIAL_CODE >", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_MATERIAL_CODE >=", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeLessThan(String value) {
            addCriterion("SUP_MATERIAL_CODE <", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_MATERIAL_CODE <=", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeLike(String value) {
            addCriterion("SUP_MATERIAL_CODE like", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeNotLike(String value) {
            addCriterion("SUP_MATERIAL_CODE not like", value, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeIn(List<String> values) {
            addCriterion("SUP_MATERIAL_CODE in", values, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeNotIn(List<String> values) {
            addCriterion("SUP_MATERIAL_CODE not in", values, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeBetween(String value1, String value2) {
            addCriterion("SUP_MATERIAL_CODE between", value1, value2, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_MATERIAL_CODE not between", value1, value2, "supMaterialCode");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupIsNull() {
            addCriterion("SUP_MATERIAL_GROUP is null");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupIsNotNull() {
            addCriterion("SUP_MATERIAL_GROUP is not null");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupEqualTo(String value) {
            addCriterion("SUP_MATERIAL_GROUP =", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupNotEqualTo(String value) {
            addCriterion("SUP_MATERIAL_GROUP <>", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupGreaterThan(String value) {
            addCriterion("SUP_MATERIAL_GROUP >", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_MATERIAL_GROUP >=", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupLessThan(String value) {
            addCriterion("SUP_MATERIAL_GROUP <", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupLessThanOrEqualTo(String value) {
            addCriterion("SUP_MATERIAL_GROUP <=", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupLike(String value) {
            addCriterion("SUP_MATERIAL_GROUP like", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupNotLike(String value) {
            addCriterion("SUP_MATERIAL_GROUP not like", value, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupIn(List<String> values) {
            addCriterion("SUP_MATERIAL_GROUP in", values, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupNotIn(List<String> values) {
            addCriterion("SUP_MATERIAL_GROUP not in", values, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupBetween(String value1, String value2) {
            addCriterion("SUP_MATERIAL_GROUP between", value1, value2, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andSupMaterialGroupNotBetween(String value1, String value2) {
            addCriterion("SUP_MATERIAL_GROUP not between", value1, value2, "supMaterialGroup");
            return (Criteria) this;
        }

        public Criteria andCountryIsNull() {
            addCriterion("COUNTRY is null");
            return (Criteria) this;
        }

        public Criteria andCountryIsNotNull() {
            addCriterion("COUNTRY is not null");
            return (Criteria) this;
        }

        public Criteria andCountryEqualTo(String value) {
            addCriterion("COUNTRY =", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotEqualTo(String value) {
            addCriterion("COUNTRY <>", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryGreaterThan(String value) {
            addCriterion("COUNTRY >", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryGreaterThanOrEqualTo(String value) {
            addCriterion("COUNTRY >=", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLessThan(String value) {
            addCriterion("COUNTRY <", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLessThanOrEqualTo(String value) {
            addCriterion("COUNTRY <=", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLike(String value) {
            addCriterion("COUNTRY like", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotLike(String value) {
            addCriterion("COUNTRY not like", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryIn(List<String> values) {
            addCriterion("COUNTRY in", values, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotIn(List<String> values) {
            addCriterion("COUNTRY not in", values, "country");
            return (Criteria) this;
        }

        public Criteria andCountryBetween(String value1, String value2) {
            addCriterion("COUNTRY between", value1, value2, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotBetween(String value1, String value2) {
            addCriterion("COUNTRY not between", value1, value2, "country");
            return (Criteria) this;
        }

        public Criteria andRegionIsNull() {
            addCriterion("REGION is null");
            return (Criteria) this;
        }

        public Criteria andRegionIsNotNull() {
            addCriterion("REGION is not null");
            return (Criteria) this;
        }

        public Criteria andRegionEqualTo(String value) {
            addCriterion("REGION =", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotEqualTo(String value) {
            addCriterion("REGION <>", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionGreaterThan(String value) {
            addCriterion("REGION >", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionGreaterThanOrEqualTo(String value) {
            addCriterion("REGION >=", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionLessThan(String value) {
            addCriterion("REGION <", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionLessThanOrEqualTo(String value) {
            addCriterion("REGION <=", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionLike(String value) {
            addCriterion("REGION like", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotLike(String value) {
            addCriterion("REGION not like", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionIn(List<String> values) {
            addCriterion("REGION in", values, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotIn(List<String> values) {
            addCriterion("REGION not in", values, "region");
            return (Criteria) this;
        }

        public Criteria andRegionBetween(String value1, String value2) {
            addCriterion("REGION between", value1, value2, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotBetween(String value1, String value2) {
            addCriterion("REGION not between", value1, value2, "region");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupIsNull() {
            addCriterion("PURCHASING_GROUP is null");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupIsNotNull() {
            addCriterion("PURCHASING_GROUP is not null");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupEqualTo(String value) {
            addCriterion("PURCHASING_GROUP =", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotEqualTo(String value) {
            addCriterion("PURCHASING_GROUP <>", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupGreaterThan(String value) {
            addCriterion("PURCHASING_GROUP >", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASING_GROUP >=", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupLessThan(String value) {
            addCriterion("PURCHASING_GROUP <", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupLessThanOrEqualTo(String value) {
            addCriterion("PURCHASING_GROUP <=", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupLike(String value) {
            addCriterion("PURCHASING_GROUP like", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotLike(String value) {
            addCriterion("PURCHASING_GROUP not like", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupIn(List<String> values) {
            addCriterion("PURCHASING_GROUP in", values, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotIn(List<String> values) {
            addCriterion("PURCHASING_GROUP not in", values, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupBetween(String value1, String value2) {
            addCriterion("PURCHASING_GROUP between", value1, value2, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotBetween(String value1, String value2) {
            addCriterion("PURCHASING_GROUP not between", value1, value2, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeIsNull() {
            addCriterion("CONDITIONAL_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeIsNotNull() {
            addCriterion("CONDITIONAL_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeEqualTo(String value) {
            addCriterion("CONDITIONAL_TYPE =", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeNotEqualTo(String value) {
            addCriterion("CONDITIONAL_TYPE <>", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeGreaterThan(String value) {
            addCriterion("CONDITIONAL_TYPE >", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeGreaterThanOrEqualTo(String value) {
            addCriterion("CONDITIONAL_TYPE >=", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeLessThan(String value) {
            addCriterion("CONDITIONAL_TYPE <", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeLessThanOrEqualTo(String value) {
            addCriterion("CONDITIONAL_TYPE <=", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeLike(String value) {
            addCriterion("CONDITIONAL_TYPE like", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeNotLike(String value) {
            addCriterion("CONDITIONAL_TYPE not like", value, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeIn(List<String> values) {
            addCriterion("CONDITIONAL_TYPE in", values, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeNotIn(List<String> values) {
            addCriterion("CONDITIONAL_TYPE not in", values, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeBetween(String value1, String value2) {
            addCriterion("CONDITIONAL_TYPE between", value1, value2, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andConditionalTypeNotBetween(String value1, String value2) {
            addCriterion("CONDITIONAL_TYPE not between", value1, value2, "conditionalType");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitIsNull() {
            addCriterion("PUR_PRICE_UNIT is null");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitIsNotNull() {
            addCriterion("PUR_PRICE_UNIT is not null");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitEqualTo(Integer value) {
            addCriterion("PUR_PRICE_UNIT =", value, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitNotEqualTo(Integer value) {
            addCriterion("PUR_PRICE_UNIT <>", value, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitGreaterThan(Integer value) {
            addCriterion("PUR_PRICE_UNIT >", value, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitGreaterThanOrEqualTo(Integer value) {
            addCriterion("PUR_PRICE_UNIT >=", value, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitLessThan(Integer value) {
            addCriterion("PUR_PRICE_UNIT <", value, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitLessThanOrEqualTo(Integer value) {
            addCriterion("PUR_PRICE_UNIT <=", value, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitIn(List<Integer> values) {
            addCriterion("PUR_PRICE_UNIT in", values, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitNotIn(List<Integer> values) {
            addCriterion("PUR_PRICE_UNIT not in", values, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitBetween(Integer value1, Integer value2) {
            addCriterion("PUR_PRICE_UNIT between", value1, value2, "purPriceUnit");
            return (Criteria) this;
        }

        public Criteria andPurPriceUnitNotBetween(Integer value1, Integer value2) {
            addCriterion("PUR_PRICE_UNIT not between", value1, value2, "purPriceUnit");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}