package com.els.base.inquiry.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.TargetM001.TargetM001JsonDeSerialzer;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonDeSerialzer;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import springfox.documentation.annotations.ApiIgnore;

@ApiModel(value="询报价-物料清单-M001")
@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=TargetM001JsonDeSerialzer.class)
public class TargetM001 extends OrderItemM001 implements ITarget {
	/**---------一下非自动生成，请勿覆盖-------------**/

	public static class TargetM001JsonDeSerialzer extends ExtendableObjectJsonDeSerialzer<TargetM001>{

		@Override
		public Class<TargetM001> getInstanceClass() {
			return TargetM001.class;
		}
	}

	@Override
	public void buildFromWaitMaterial(String templateId,InquiryWaitMaterial waitMaterial) {
		// TODO 待完善
		setWaitMaterialId(waitMaterial.getId());//物料id
		setMaterialCode(waitMaterial.getMaterialCode());//物料编码
		setInfoCategory(waitMaterial.getInfoCategory());//信息类别
		setPurchaseApply(waitMaterial.getPurchaseApply());//采购申请
		setProject(waitMaterial.getProject());//行项目号
		setQuantity(waitMaterial.getApplyQuantity().longValue());//申请数量
		setMaterialType(ITarget.MATERIAL_TYPE_WAIT);
		setUnableToQuote(null);

		setTemplateId(templateId);
	}

	@JsonIgnore
	@Override
	public List<PropertyDef> getPropertyDefList() {
		if (StringUtils.isNotBlank(this.getTemplateId())) {
			TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(this.getTemplateId());
			return templateConf.getOrderItemPropertyDefList();

		}else if(StringUtils.isNotBlank(this.getPurOrderId())){
			PurOrder purOrder = SpringContextHolder.getOneBean(PurOrderService.class).queryObjById(this.getPurOrderId());
			if (purOrder!=null && StringUtils.isNotBlank(purOrder.getTemplateId())) {
				TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(this.getPurOrderId());
				return templateConf.getOrderItemPropertyDefList();
			}
		}
		return PropertyDefUtils.getProperyDefByClass(this.getClass());
	}

	@ApiModelProperty("阶梯报价")
	private List<InquiryQuoteLadder> inquiryQuoteLadders;

	public List<InquiryQuoteLadder> getInquiryQuoteLadders() {
		return inquiryQuoteLadders;
	}

	public void setInquiryQuoteLadders(List<InquiryQuoteLadder> inquiryQuoteLadders) {
		this.inquiryQuoteLadders = inquiryQuoteLadders;
	}

	private List<PropertyValue> propertyValueList;

	@JsonIgnore
	@ApiIgnore
	public List<PropertyValue> getPropertyValueList() {
		return propertyValueList;
	}

	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}

	/**------------------end---------------------**/

	@ApiModelProperty(name="主键", hidden=true)
    private String id;

    @ApiModelProperty(name="采购方表头id", hidden=true)
    private String purOrderId;

    @ApiModelProperty(name="供应方表头id", hidden=true)
    private String supOrderId;

    @ApiModelProperty(name="询价单号", hidden=true)
    private String orderNo;

    @ApiModelProperty(name="询价单行号(采购方)", hidden=true)
    private Integer orderItemNo;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("排序号(供应商行号)")
    private Integer sortNo;

    @ApiModelProperty("不含税单价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("操作(1接受，0拒绝)")
    private Integer operation;

    @ApiModelProperty("报价状态")
    private Integer quotationStatus;

    @ApiModelProperty("定价说明")
    private String pricingDescription;

    @ApiModelProperty("供应商编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty("申请日期")
    private Date offerTime;

    @ApiModelProperty("报价人")
    private String bidder;

    @ApiModelProperty("无法报价")
    private Integer unableToQuote;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("模板ID")
    private String templateId;

    @ApiModelProperty("待询价物料ID")
    private String waitMaterialId;

    @ApiModelProperty("报价方式，1常规报价，2阶梯报价")
    private Integer quoteType;

    @ApiModelProperty("报价人id")
    private String bidderId;

    @ApiModelProperty("完成时间")
    private Date finishTime;

    @ApiModelProperty("模具编码")
    private String mouldCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty(position=-1, value="报价人")
    private String supUserName;

    @ApiModelProperty(position=-1, value="报价时间")
    private Date quoteTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("图号")
    private String mapNo;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("数量")
    private Long quantity;

    @ApiModelProperty("最近一次采购不含税单价")
    private BigDecimal recentUntaxedUnitPrice;

    @ApiModelProperty("降幅")
    private String decreasingAmplitude;

    @ApiModelProperty("含税单价")
    private BigDecimal taxedUnitPrice;

    @ApiModelProperty("参考零部件图号")
    private String referPartMapNo;

    @ApiModelProperty("参考零部件价格")
    private BigDecimal referPartPrice;

    @ApiModelProperty("信息类别")
    private String infoCategory;

    @ApiModelProperty("交货周期")
    private Integer planDeliveryDate;

    @ApiModelProperty("采购组")
    private String purchaseGroup;

    @ApiModelProperty("标准采购订单数量")
    private BigDecimal purOrderQuantity;

    @ApiModelProperty("最小订单数量")
    private BigDecimal minOrderQuantity;

    @ApiModelProperty("价格单位（每多少个）")
    private Integer priceUnit;

    @ApiModelProperty("有效期从")
    private Date validDateFrom;

    @ApiModelProperty("有效期到")
    private Date validDateTo;

    @ApiModelProperty("采购申请")
    private String purchaseApply;

    @ApiModelProperty("行号")
    private String project;

    @ApiModelProperty("价格变化原因编码")
    private String priceChangeCode;

    @ApiModelProperty("价格变化原因描述")
    private String priceChangeReasons;

    @ApiModelProperty("影响部门编码")
    private String affectDepartmentCode;

    @ApiModelProperty("影响部门编码表述")
    private String affectDepartmentDesc;

    @ApiModelProperty("物料来源")
    private String materialType;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getSupOrderId() {
        return supOrderId;
    }

    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public Integer getOrderItemNo() {
        return orderItemNo;
    }

    public void setOrderItemNo(Integer orderItemNo) {
        this.orderItemNo = orderItemNo;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public Integer getOperation() {
        return operation;
    }

    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    public Integer getQuotationStatus() {
        return quotationStatus;
    }

    public void setQuotationStatus(Integer quotationStatus) {
        this.quotationStatus = quotationStatus;
    }

    public String getPricingDescription() {
        return pricingDescription;
    }

    public void setPricingDescription(String pricingDescription) {
        this.pricingDescription = pricingDescription == null ? null : pricingDescription.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public Date getOfferTime() {
        return offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    public String getBidder() {
        return bidder;
    }

    public void setBidder(String bidder) {
        this.bidder = bidder == null ? null : bidder.trim();
    }

    public Integer getUnableToQuote() {
        return unableToQuote;
    }

    public void setUnableToQuote(Integer unableToQuote) {
        this.unableToQuote = unableToQuote;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getWaitMaterialId() {
        return waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    public Integer getQuoteType() {
        return quoteType;
    }

    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }

    public String getBidderId() {
        return bidderId;
    }

    public void setBidderId(String bidderId) {
        this.bidderId = bidderId == null ? null : bidderId.trim();
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getMapNo() {
        return mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Long getQuantity() {
        return quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getRecentUntaxedUnitPrice() {
        return recentUntaxedUnitPrice;
    }

    public void setRecentUntaxedUnitPrice(BigDecimal recentUntaxedUnitPrice) {
        this.recentUntaxedUnitPrice = recentUntaxedUnitPrice;
    }

    public String getDecreasingAmplitude() {
        return decreasingAmplitude;
    }

    public void setDecreasingAmplitude(String decreasingAmplitude) {
        this.decreasingAmplitude = decreasingAmplitude == null ? null : decreasingAmplitude.trim();
    }

    public BigDecimal getTaxedUnitPrice() {
        return taxedUnitPrice;
    }

    public void setTaxedUnitPrice(BigDecimal taxedUnitPrice) {
        this.taxedUnitPrice = taxedUnitPrice;
    }

    public String getReferPartMapNo() {
        return referPartMapNo;
    }

    public void setReferPartMapNo(String referPartMapNo) {
        this.referPartMapNo = referPartMapNo == null ? null : referPartMapNo.trim();
    }

    public BigDecimal getReferPartPrice() {
        return referPartPrice;
    }

    public void setReferPartPrice(BigDecimal referPartPrice) {
        this.referPartPrice = referPartPrice;
    }

    public String getInfoCategory() {
        return infoCategory;
    }

    public void setInfoCategory(String infoCategory) {
        this.infoCategory = infoCategory == null ? null : infoCategory.trim();
    }

    public Integer getPlanDeliveryDate() {
        return planDeliveryDate;
    }

    public void setPlanDeliveryDate(Integer planDeliveryDate) {
        this.planDeliveryDate = planDeliveryDate;
    }

    public String getPurchaseGroup() {
        return purchaseGroup;
    }

    public void setPurchaseGroup(String purchaseGroup) {
        this.purchaseGroup = purchaseGroup == null ? null : purchaseGroup.trim();
    }

    public BigDecimal getPurOrderQuantity() {
        return purOrderQuantity;
    }

    public void setPurOrderQuantity(BigDecimal purOrderQuantity) {
        this.purOrderQuantity = purOrderQuantity;
    }

    public BigDecimal getMinOrderQuantity() {
        return minOrderQuantity;
    }

    public void setMinOrderQuantity(BigDecimal minOrderQuantity) {
        this.minOrderQuantity = minOrderQuantity;
    }

    public Integer getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(Integer priceUnit) {
        this.priceUnit = priceUnit;
    }

    public Date getValidDateFrom() {
        return validDateFrom;
    }

    public void setValidDateFrom(Date validDateFrom) {
        this.validDateFrom = validDateFrom;
    }

    public Date getValidDateTo() {
        return validDateTo;
    }

    public void setValidDateTo(Date validDateTo) {
        this.validDateTo = validDateTo;
    }

    public String getPurchaseApply() {
        return purchaseApply;
    }

    public void setPurchaseApply(String purchaseApply) {
        this.purchaseApply = purchaseApply == null ? null : purchaseApply.trim();
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public String getPriceChangeCode() {
        return priceChangeCode;
    }

    public void setPriceChangeCode(String priceChangeCode) {
        this.priceChangeCode = priceChangeCode == null ? null : priceChangeCode.trim();
    }

    public String getPriceChangeReasons() {
        return priceChangeReasons;
    }

    public void setPriceChangeReasons(String priceChangeReasons) {
        this.priceChangeReasons = priceChangeReasons == null ? null : priceChangeReasons.trim();
    }

    public String getAffectDepartmentCode() {
        return affectDepartmentCode;
    }

    public void setAffectDepartmentCode(String affectDepartmentCode) {
        this.affectDepartmentCode = affectDepartmentCode == null ? null : affectDepartmentCode.trim();
    }

    public String getAffectDepartmentDesc() {
        return affectDepartmentDesc;
    }

    public void setAffectDepartmentDesc(String affectDepartmentDesc) {
        this.affectDepartmentDesc = affectDepartmentDesc == null ? null : affectDepartmentDesc.trim();
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType == null ? null : materialType.trim();
    }

}