package com.els.base.inquiry.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.IBusiCondition;
import com.els.base.inquiry.IBusiConditionService;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldService;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.ITargetService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-模板配置信息")
public class TemplateConf implements Serializable {
	
	/*-------------以下非自动生成，不要覆盖--------------------*/
	/**
	 * 获取订单行的实体类
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@JsonIgnore
	public Class<? extends IOrderItem> getOrderItemClass() {
		if (StringUtils.isNotBlank(this.getItemClassName())) {
			return ClassReflectionUtils.getClassByName(this.getItemClassName());
		}
		
		return InquiryConstant.DEFALUT_ORDER_TIEM_CLS;
    }
	/**
	 * 获取订单行的service类
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@JsonIgnore
	public IOrderItemService getOrderItemService() {
		
		IOrderItem item = ClassReflectionUtils.newInstatnce(this.getOrderItemClass());
		try {
			item = this.getOrderItemClass().newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			e.printStackTrace();
		}
		Class itemServiceCls = item.getOrderItemService();
		return (IOrderItemService) SpringContextHolder.getOneBean(itemServiceCls);
	}
	
	/**
	 * 获取模具清单的实体类
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@JsonIgnore
	public Class<? extends IMould> getMouldClass() {
		if (StringUtils.isNotBlank(this.getMouldClassName())) {
			return ClassReflectionUtils.getClassByName(this.getMouldClassName());
		}
		
		return InquiryConstant.DEFALUT_MOULD_CLS;
	}
	/**
	 * 获取模具清单的Service类
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@JsonIgnore
	public IMouldService getMouldService() {
		Class mouldServiceCls = null;
		if (StringUtils.isNotBlank(this.getMouldServiceClassName())) {
			mouldServiceCls = ClassReflectionUtils.getClassByName(this.getMouldServiceClassName());
		}else{
			mouldServiceCls = InquiryConstant.DEFALUT_MOULD_SERVICE_CLS; 
		}
		
		return (IMouldService) SpringContextHolder.getOneBean(mouldServiceCls);
	}
	
	/**
	 * 获取商务条件的实体类
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@JsonIgnore
	public Class<? extends IBusiCondition> getBusiConditionClass() {
		if (StringUtils.isNotBlank(this.getBusiCondClassName())) {
			return ClassReflectionUtils.getClassByName(this.getBusiCondClassName());
		}
		
		return InquiryConstant.DEFALUT_BUSI_CONDITION_CLS;
	}
	/**
	 * 获取商务条件的service类
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@JsonIgnore
	public IBusiConditionService getBusiConditionService() {
		Class busiConditionService = null;
		if (StringUtils.isNotBlank(this.getBusiCondServiceClassName())) {
			busiConditionService = ClassReflectionUtils.getClassByName(this.getBusiCondServiceClassName());
		}else{
			busiConditionService = InquiryConstant.DEFALUT_BUSI_CONDITION_SERVICE_CLS; 
		}
		
		return (IBusiConditionService) SpringContextHolder.getOneBean(busiConditionService);
	}
	
	/**
	 * 获取物料清单class
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@JsonIgnore
	public Class<? extends ITarget> getTargetClass(){
		if (StringUtils.isNotBlank(this.getTargetClassName())) {
			return ClassReflectionUtils.getClassByName(this.getTargetClassName());
		}
		return InquiryConstant.DEFALUT_TARGET_CLS;
	}
	
	/**
	 * 获取物料清单class
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@JsonIgnore
	public ITargetService getTargetService(){
		Class<? extends ITargetService> targetService = null;
		if (StringUtils.isNotBlank(this.getTargetServiceClassName())) {
			targetService = ClassReflectionUtils.getClassByName(this.getTargetServiceClassName());
		}else{
			targetService = InquiryConstant.DEFALUT_TARGET_SERVICE_CLS; 
		}
		
		return (ITargetService) SpringContextHolder.getOneBean(targetService);
	}
	
	@ApiModelProperty("订单行字段列表")
	List<PropertyDef> orderItemPropertyDefList;
	
	@ApiModelProperty("模具字段列表")
	List<PropertyDef> mouldPropertyDefList;
	
	@ApiModelProperty("商务条件字段列表")
	List<PropertyDef> busiConditionPropertyDefList;
	
	@ApiModelProperty("模具成本清单模板")
	private TplMouldDetail tplMouLdDetail;
	
	@ApiModelProperty("物料成本清单模板")
	private TplOrderItemDetail tplOrderItemDetail;
	
    public List<PropertyDef> getOrderItemPropertyDefList() {
		return orderItemPropertyDefList;
	}

	public void setOrderItemPropertyDefList(List<PropertyDef> orderItemPropertyDefList) {
		this.orderItemPropertyDefList = orderItemPropertyDefList;
	}

	public List<PropertyDef> getMouldPropertyDefList() {
		return mouldPropertyDefList;
	}

	public void setMouldPropertyDefList(List<PropertyDef> mouldPropertyDefList) {
		this.mouldPropertyDefList = mouldPropertyDefList;
	}

	public List<PropertyDef> getBusiConditionPropertyDefList() {
		return busiConditionPropertyDefList;
	}

	public void setBusiConditionPropertyDefList(List<PropertyDef> busiConditionPropertyDefList) {
		this.busiConditionPropertyDefList = busiConditionPropertyDefList;
	}
	
    public TplMouldDetail getTplMouLdDetail() {
		return tplMouLdDetail;
	}

	public void setTplMouLdDetail(TplMouldDetail tplMouLdDetail) {
		this.tplMouLdDetail = tplMouLdDetail;
	}

	public TplOrderItemDetail getTplOrderItemDetail() {
		return tplOrderItemDetail;
	}

	public void setTplOrderItemDetail(TplOrderItemDetail tplOrderItemDetail) {
		this.tplOrderItemDetail = tplOrderItemDetail;
	}

	/*-------------以下非自动生成，不要覆盖， end--------------------*/
	
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("模板分类编码")
    private String categoryCode;

    @ApiModelProperty("模板分类名称")
    private String categoryName;

    @ApiModelProperty("模板编码")
    private String code;

    @ApiModelProperty("模板名称")
    private String name;

    @ApiModelProperty("询价目标class名称")
    private String targetClassName;

    @ApiModelProperty("询价目标service名称")
    private String targetServiceClassName;

    @ApiModelProperty("询价单行class")
    private String itemClassName;

    @ApiModelProperty("询价单行service")
    private String itemServiceClassName;

    @ApiModelProperty("商务条件class")
    private String busiCondClassName;

    @ApiModelProperty("商务条件service")
    private String busiCondServiceClassName;

    @ApiModelProperty("是否要阶梯报价")
    private Integer isLadderPriceEnable;

    @ApiModelProperty("是否显示商务条件")
    private Integer isBusiCondEnable;

    @ApiModelProperty("是否显示模板清单")
    private Integer isMouldEnable;

    @ApiModelProperty("是否显示模具成本清单")
    private Integer isMouldDetailEnable;

    @ApiModelProperty("是否显示表单文件")
    private Integer isAttachmentEnable;

    @ApiModelProperty("是否显示物料成本清单")
    private Integer isOrderItemDetailEnable;

    @ApiModelProperty("模具清单class")
    private String mouldClassName;

    @ApiModelProperty("模具清单service")
    private String mouldServiceClassName;

    @ApiModelProperty("物料成本清单模板id")
    private String orderItemDtlTplId;

    @ApiModelProperty("模具成本清单模板id")
    private String mouldItemDtlTplId;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建人id")
    private String createUserId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("是否是历史版本")
    private Integer isHis;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode == null ? null : categoryCode.trim();
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName == null ? null : categoryName.trim();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getTargetClassName() {
        return targetClassName;
    }

    public void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName == null ? null : targetClassName.trim();
    }

    public String getTargetServiceClassName() {
        return targetServiceClassName;
    }

    public void setTargetServiceClassName(String targetServiceClassName) {
        this.targetServiceClassName = targetServiceClassName == null ? null : targetServiceClassName.trim();
    }

    public String getItemClassName() {
        return itemClassName;
    }

    public void setItemClassName(String itemClassName) {
        this.itemClassName = itemClassName == null ? null : itemClassName.trim();
    }

    public String getItemServiceClassName() {
        return itemServiceClassName;
    }

    public void setItemServiceClassName(String itemServiceClassName) {
        this.itemServiceClassName = itemServiceClassName == null ? null : itemServiceClassName.trim();
    }

    public String getBusiCondClassName() {
        return busiCondClassName;
    }

    public void setBusiCondClassName(String busiCondClassName) {
        this.busiCondClassName = busiCondClassName == null ? null : busiCondClassName.trim();
    }

    public String getBusiCondServiceClassName() {
        return busiCondServiceClassName;
    }

    public void setBusiCondServiceClassName(String busiCondServiceClassName) {
        this.busiCondServiceClassName = busiCondServiceClassName == null ? null : busiCondServiceClassName.trim();
    }

    public Integer getIsLadderPriceEnable() {
        return isLadderPriceEnable;
    }

    public void setIsLadderPriceEnable(Integer isLadderPriceEnable) {
        this.isLadderPriceEnable = isLadderPriceEnable;
    }

    public Integer getIsBusiCondEnable() {
        return isBusiCondEnable;
    }

    public void setIsBusiCondEnable(Integer isBusiCondEnable) {
        this.isBusiCondEnable = isBusiCondEnable;
    }

    public Integer getIsMouldEnable() {
        return isMouldEnable;
    }

    public void setIsMouldEnable(Integer isMouldEnable) {
        this.isMouldEnable = isMouldEnable;
    }

    public Integer getIsMouldDetailEnable() {
        return isMouldDetailEnable;
    }

    public void setIsMouldDetailEnable(Integer isMouldDetailEnable) {
        this.isMouldDetailEnable = isMouldDetailEnable;
    }

    public Integer getIsAttachmentEnable() {
        return isAttachmentEnable;
    }

    public void setIsAttachmentEnable(Integer isAttachmentEnable) {
        this.isAttachmentEnable = isAttachmentEnable;
    }

    public Integer getIsOrderItemDetailEnable() {
        return isOrderItemDetailEnable;
    }

    public void setIsOrderItemDetailEnable(Integer isOrderItemDetailEnable) {
        this.isOrderItemDetailEnable = isOrderItemDetailEnable;
    }

    public String getMouldClassName() {
        return mouldClassName;
    }

    public void setMouldClassName(String mouldClassName) {
        this.mouldClassName = mouldClassName == null ? null : mouldClassName.trim();
    }

    public String getMouldServiceClassName() {
        return mouldServiceClassName;
    }

    public void setMouldServiceClassName(String mouldServiceClassName) {
        this.mouldServiceClassName = mouldServiceClassName == null ? null : mouldServiceClassName.trim();
    }

    public String getOrderItemDtlTplId() {
        return orderItemDtlTplId;
    }

    public void setOrderItemDtlTplId(String orderItemDtlTplId) {
        this.orderItemDtlTplId = orderItemDtlTplId == null ? null : orderItemDtlTplId.trim();
    }

    public String getMouldItemDtlTplId() {
        return mouldItemDtlTplId;
    }

    public void setMouldItemDtlTplId(String mouldItemDtlTplId) {
        this.mouldItemDtlTplId = mouldItemDtlTplId == null ? null : mouldItemDtlTplId.trim();
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsHis() {
        return isHis;
    }

    public void setIsHis(Integer isHis) {
        this.isHis = isHis;
    }
}