package com.els.base.inquiry.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-模具成本清单模板")
public class TplMouldDetail implements Serializable {
	
	/**------------以下代码请勿覆盖---------------*/
	
	/**
	 * 获取模具成本清单的实体类
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@JsonIgnore
	public Class<? extends IMouldDetail> getMouldDetailClass() {
		if (StringUtils.isNotBlank(this.getMouldDtlClassName())) {
			return ClassReflectionUtils.getClassByName(this.getMouldDtlClassName());
		}
		
		return InquiryConstant.DEFALUT_MOULD_DETAIL_CLS;
	}
	/**
	 * 获取模具成本清单的service类
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@JsonIgnore
	public IMouldDetailService getMouldDetailService() {
		Class mouldDetailService = null;
		if (StringUtils.isNotBlank(this.getMouldDtlServiceName())) {
			mouldDetailService = ClassReflectionUtils.getClassByName(this.getMouldDtlServiceName());
		}else{
			mouldDetailService = InquiryConstant.DEFALUT_MOULD_DETAIL_SERVICE_CLS; 
		}
		
		return (IMouldDetailService) SpringContextHolder.getOneBean(mouldDetailService);
	}
	
	private List<PropertyDef> propertyDefList;
	
	public List<PropertyDef> getPropertyDefList() {
		return propertyDefList;
	}
	
	public void setPropertyDefList(List<PropertyDef> propertyDefList) {
		this.propertyDefList = propertyDefList;
	}
	
	/**------------以上代码请勿覆盖---------------*/

	
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("模板编码")
    private String code;

    @ApiModelProperty("模板名称")
    private String name;

    @ApiModelProperty("模具清单class名称")
    private String mouldDtlClassName;

    @ApiModelProperty("模具清单service名称")
    private String mouldDtlServiceName;

    @ApiModelProperty("是否是历史版本，1是，0否")
    private Integer isHis;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建人id")
    private String createUserId;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getMouldDtlClassName() {
        return mouldDtlClassName;
    }

    public void setMouldDtlClassName(String mouldDtlClassName) {
        this.mouldDtlClassName = mouldDtlClassName == null ? null : mouldDtlClassName.trim();
    }

    public String getMouldDtlServiceName() {
        return mouldDtlServiceName;
    }

    public void setMouldDtlServiceName(String mouldDtlServiceName) {
        this.mouldDtlServiceName = mouldDtlServiceName == null ? null : mouldDtlServiceName.trim();
    }

    public Integer getIsHis() {
        return isHis;
    }

    public void setIsHis(Integer isHis) {
        this.isHis = isHis;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId == null ? null : createUserId.trim();
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }
}