package com.els.base.inquiry.entity.detail;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.els.base.inquiry.AbstractOrderItemDetail;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.service.detail.OrderItemDetailServiceImpl;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-报价明细L001")
@JsonSerialize(using=DetailSerialzer.class)
public class OrderItemDetail extends AbstractOrderItemDetail {
	
	/*------------请勿覆盖-------------------*/

	private List<PropertyValue> propertyValueList;
	
	@Override
	public List<PropertyValue> getPropertyValueList() {
		return this.propertyValueList;
	}

	@Override
	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class<? extends IOrderItemDetailService> getItemDetailService() {
		return OrderItemDetailServiceImpl.class;
	}
	
	@Override
	public BigDecimal calculate() {
		return this.untaxedUnitPrice;
	}
	
	@Override
	public void build(IOrderItem item) {
		OrderItemM001 m001 = (OrderItemM001) item;
		this.setMaterialCode(m001.getMaterialCode());
		this.setOrderItemId(m001.getId());
	}
	/*------------请勿覆盖-------------------*/

	
    @ApiModelProperty(hidden=true, value="主键")
    private String id;

    @ApiModelProperty(hidden=true, value="行数据ID")
    private String orderItemId;

    @ApiModelProperty(hidden=true, value="排序号")
    private Integer sortNo;

    @ApiModelProperty("使用材料")
    private String mouldCode;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("品名")
    private String brand;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty(hidden=true, value="创建时间")
    private Date createTime;

    @ApiModelProperty(hidden=true, value="更新时间")
    private Date updateTime;

    @ApiModelProperty(hidden=true, value="记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty(hidden=true, value="模板id")
    private String templateId;

    @ApiModelProperty("不含税单价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal taxUnitPrice;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getOrderItemId() {
        return orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId == null ? null : orderItemId.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand == null ? null : brand.trim();
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public BigDecimal getTaxUnitPrice() {
        return taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }

}