package com.els.base.inquiry.enumclass;

/**
 * 询价单审批状态
 *
 */
public enum InquiryAuditStatus {

	UNAUDITED(1, "未审批"),
	AUDITING(2,"审批中"),
	AUDIT_PASS(3,"审批通过"),
	AUDIT_REJECT(4,"审批驳回");

	private Integer code;
	private String name;
	
	private InquiryAuditStatus(Integer code, String name) {
		this.code = code;
		this.name = name;
	}
	
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

}
