package com.els.base.inquiry.enumclass;

/**
 * 询价单状态
 *
 */
public enum InquiryOrderStatus {

	/**未发布**/
	UNPUBLISHED(1, "未发布"),
	/**已发布**/
	PUBLISHED(2, "已发布"),
	/**已完成**/
	FINISHED(3,"已完成"),
	/**已作废**/
	INVALID(4,"已作废"),
	/**已删除**/
	DELETE(5,"已删除"),	
	FROZEN(6,"已冻结"),
	ACCEPTED(7,"已接受"),
	ACCEPT_SECTION(8,"部分接受"),
	REFUSED(9,"已拒绝");
	

	private Integer code;
	
	private String name;
	
	private InquiryOrderStatus(Integer code, String name) {
		this.code = code;
		this.name = name;
	}
	public Integer getCode() {
		return code;
	}
	public void setCode(int code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
}
