package com.els.base.inquiry.enumclass;

import com.els.base.core.exception.CommonException;

/**
 * 询价单阶梯报价类型
 *
 */
public enum InquiryQuoteLadderType {

	CONVENTIONAL_QUOTE(1, "常规报价"),
	LADDER_QUOTE(2,"阶梯报价");

	private Integer code;
	private String name;

	private InquiryQuoteLadderType(int code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public static String getNameByCode(Integer code) {
		if (code == null) {
			return null;
		}
		
		switch (code) {
		case 1:
			return "常规报价";
		case 2:
			return "阶梯报价";

		default:
			throw new CommonException("报价方式无法识别");
		}
	}

}
