package com.els.base.inquiry.enumclass;

import com.els.base.core.exception.CommonException;

/**
 * 报价状态
 *
 */
public enum InquiryQuoteStatus {

	/**未报价**/
	UNQUOTED(1, "未报价"),
	/**已报价**/
	QUOTED(2, "已报价"),
	/**部分报价**/
	QUOTE_SECTION(3,"部分报价"),
	/**重报价**/
	REQUOTE(4,"重报价"),
	/**已重报**/
	REQUOTED(5,"已重报");
	
	private Integer code;
	
	private String name;
	
	private InquiryQuoteStatus(int code, String name) {
		this.code = code;
		this.name = name;
	}
	
	public Integer getCode() {
		return code;
	}
	public void setCode(int code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static String getNameByCode(String code){
		if (code == null) {
			return null;
		}
		
		switch (code) {
		case "1":
			return "未报价";
		case "2":
			return "已报价";
		case "3":
			return "部分报价";
		case "4":
			return "重报价";
		case "5":
			return "已重报";
		default:
			throw new CommonException("状态无法识别");
		}
	}
	
}
