package com.els.base.inquiry.enumclass;

public enum OperationTypeEnum {
	
	ACCEPTED(1, "已接受"),
	REFUSED(0,"已拒绝"),
	NO_OPERATION(-1,"没有操作");
	
	private Integer code;
	private String name;
	
	private OperationTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}
	
	public Integer getCode() {
		return code;
	}
	public void setCode(Integer code) {
		this.code = code;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * 是否 定价的操作
	 * @param orderItem
	 * @return
	 */
	public static boolean isPricingOperation(Integer operation){
		if (ACCEPTED.getCode().equals(operation)
				|| REFUSED.getCode().equals(operation)) {
			return true;
		}
		return false;
	}

}
