package com.els.base.inquiry.event;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.ApprovePassCommand;
import com.els.base.inquiry.command.pur.ApproveRefuseCommand;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;

@Component
public class ApprovePassListener implements ITaskListener {
	
	@Resource
	protected PurOrderService purOrderService;
	
	@Resource
	protected InquiryCommandInvoker invoker;

	@Override
	public void listen(TaskOperateEvent event) {
    	if(event==null){
    		return;
	    }
    	String purOrderId = event.getBusinessId();
    	
    	if (!event.isPass()) {
    		// 更新询价单头状态为审批拒绝
    		ApproveRefuseCommand cmd = new ApproveRefuseCommand(purOrderId);
    		cmd.setPurUser(event.getAssigneeUser());
    		invoker.invoke(cmd);
    		return;
		}
    	
	    if (!event.isFinished()) {
	    	// 如果审批流程还没有结束
			return;
		}
    	
    	ApprovePassCommand cmd = new ApprovePassCommand(purOrderId);
    	cmd.setPurUser(event.getAssigneeUser());
    	invoker.invoke(cmd);
    	
	}

}
