package com.els.base.inquiry.service;

import java.math.BigDecimal;
import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;

public interface InquiryQuoteLadderService extends BaseService<InquiryQuoteLadder, InquiryQuoteLadderExample, String> {

	void deleteByExample(InquiryQuoteLadderExample example);
	
	public BigDecimal queryLowestPriceForItem(String itemId);

	void addAll(List<InquiryQuoteLadder> totalinquiryQuoteLadder);

	/**
	 * 根据物料清单，查询关联阶梯报价
	 * @param targetId
	 * @return
	 */
	List<InquiryQuoteLadder> queryByTargetId(String targetId);

	/**
	 * 根据询价单行，查询关联的阶梯报价
	 * @param id
	 * @return
	 */
	List<InquiryQuoteLadder> queryByOrderItemId(String id);

	/**
	 * 批量修改询报价阶梯报价数据
	 * @param tempLadder
	 * @param example
	 */
	void modifyByExample(InquiryQuoteLadder tempLadder, InquiryQuoteLadderExample example);
}