package com.els.base.inquiry.service;

import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;

public interface InquiryWaitMaterialService extends BaseService<InquiryWaitMaterial, InquiryWaitMaterialExample, String> {

	List<ITarget> transformToPurOrderMaterial(WaitMaterialTransformVo waitMaterialTransformVo);
	
	/**
	 * 批量修改带询价物料
	 * @param waitMaterial
	 * @param example
	 */
	void modifyByExample(InquiryWaitMaterial waitMaterial, InquiryWaitMaterialExample example);
	
	/**
	 * 批量保存待询价物料
	 * @param waitMaterials
	 */
	void batchInsertWaitMaterial(List<InquiryWaitMaterial> waitMaterials);
}