package com.els.base.inquiry.service;

import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyDefExample;

public interface PropertyDefService extends BaseService<PropertyDef, PropertyDefExample, String> {
	
	/**
	 * 根据模板id，与模板类型，查询的自定义字段
	 * @param templateId
	 * @return
	 */
	List<PropertyDef> queryPropertyDefList(String templateId, String tplType);
	
	/**
	 * 根据模板id，与模板类型，查询的自定义字段
	 * @param templateId
	 * @return
	 */
	List<PropertyDef> queryHisPropertyDefList(String templateId, String tplType);

	/**
	 * 根据模板id，删除所有字段定义
	 * @param id
	 * @param code
	 */
	void removeAllByTpl(String tplId, String propertyTplTypeCod);

	/**
	 * 根据模板id，将所有字段定义放到历史表
	 * @param id
	 * @param code
	 */
	void moveAllToHisByTpl(String tplId, String propertyTplTypeCod);
	
	/**
	 * 批量添加
	 * @param propertyDefList
	 */
	void addAll(List<PropertyDef> propertyDefList);
}