package com.els.base.inquiry.service;

import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PropertyValueExample;

public interface PropertyValueService extends BaseService<PropertyValue, PropertyValueExample, String> {
	
	/**
	 * 根据id，查询这个模板是否已经产生具体的业务数据
	 * @param tplId
	 * @param propertyDefTplTypeCode
	 * @return
	 */
	public boolean isContainTpl(String tplId, String propertyDefTplTypeCode);

	/**
	 * 批量插入字段定义值
	 * @param propertyValueList
	 */
	public void addAll(List<PropertyValue> propertyValueList);
	
	/**
	 * 批量删除
	 * @param propertyValueExample
	 */
	public void deleteByExample(PropertyValueExample propertyValueExample);
	
	
}