package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.InformationRecordMapper;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.service.InformationRecordService;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultInformationRecordService")
public class InformationRecordServiceImpl implements InformationRecordService {
    @Resource
    protected InformationRecordMapper informationRecordMapper;

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    @Override
    public void addObj(InformationRecord t) {
        this.informationRecordMapper.insertSelective(t);
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.informationRecordMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    @Override
    public void modifyObj(InformationRecord t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.informationRecordMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="informationRecord", keyGenerator="redisKeyGenerator")
    @Override
    public InformationRecord queryObjById(String id) {
        return this.informationRecordMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="informationRecord", keyGenerator="redisKeyGenerator")
    @Override
    public List<InformationRecord> queryAllObjByExample(InformationRecordExample example) {
        return this.informationRecordMapper.selectByExample(example);
    }

    @Cacheable(value="informationRecord", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<InformationRecord> queryObjByPage(InformationRecordExample example) {
        PageView<InformationRecord> pageView = example.getPageView();
        pageView.setQueryResult(this.informationRecordMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"informationRecord"}, allEntries=true)
    @Override
    public void addAll(List<InformationRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.informationRecordMapper.insertSelective(item);
            }
        });
        
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    @Override
    public void deleteByExample(InformationRecordExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.informationRecordMapper.deleteByExample(arg0);
        
    }
}