package com.els.base.inquiry.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquiryBusiConditionMapper;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.InquiryBusiConditionService;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultInquiryBusiConditionService")
public class InquiryBusiConditionServiceImpl implements InquiryBusiConditionService {
    @Resource
    protected InquiryBusiConditionMapper inquiryBusiConditionMapper;
    
    @Resource
	private PropertyValueService propertyValueService;

    @CacheEvict(value={"inquiryBusiCondition"}, allEntries=true)
    @Override
    public void addObj(InquiryBusiCondition t) {
        this.inquiryBusiConditionMapper.insertSelective(t);
        
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.BUSI_TYPE.getCode());
    }

    @CacheEvict(value={"inquiryBusiCondition"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.inquiryBusiConditionMapper.deleteByPrimaryKey(id);
        
        PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.BUSI_TYPE.getCode());
    }

    @CacheEvict(value={"inquiryBusiCondition"}, allEntries=true)
    @Override
    public void modifyObj(InquiryBusiCondition t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.inquiryBusiConditionMapper.updateByPrimaryKeySelective(t);
        
        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.BUSI_TYPE.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.BUSI_TYPE.getCode());
        
    }

    @Cacheable(value="inquiryBusiCondition", keyGenerator="redisKeyGenerator")
    @Override
    public InquiryBusiCondition queryObjById(String id) {
        InquiryBusiCondition busiCondition = this.inquiryBusiConditionMapper.selectByPrimaryKey(id);
        PropertyValueUtils.queryAndSetValue(Arrays.asList(busiCondition), PropertyDefTplType.BUSI_TYPE.getCode());
        return busiCondition;
    }

    @Cacheable(value="inquiryBusiCondition", keyGenerator="redisKeyGenerator")
    @Override
    public List<InquiryBusiCondition> queryAllObjByExample(InquiryBusiConditionExample example) {
        List<InquiryBusiCondition> list = this.inquiryBusiConditionMapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.BUSI_TYPE.getCode());
        return list;
    }

    @Cacheable(value="inquiryBusiCondition", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<InquiryBusiCondition> queryObjByPage(InquiryBusiConditionExample example) {
        PageView<InquiryBusiCondition> pageView = example.getPageView();
        List<InquiryBusiCondition> list = this.inquiryBusiConditionMapper.selectByExampleByPage(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.BUSI_TYPE.getCode());
        pageView.setQueryResult(list);
        return pageView;
    }

    @CacheEvict(value={"inquiryBusiCondition"}, allEntries=true)
	@Override
	public void deleteByExample(InquiryBusiConditionExample example) {
    	if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
			return;
		}
    	
    	List<InquiryBusiCondition> list = this.inquiryBusiConditionMapper.selectByExample(example);
    	
    	List<String> idList = list.stream().map(InquiryBusiCondition::getId).collect(Collectors.toList());
    	PropertyValueUtils.deleteByExtenable(idList, PropertyDefTplType.BUSI_TYPE.getCode());
    	
		this.inquiryBusiConditionMapper.deleteByExample(example);
		
	}

    @CacheEvict(value={"inquiryBusiCondition"}, allEntries=true)
	@Override
	public void addAll(List<InquiryBusiCondition> busiConditionList) {
		if (CollectionUtils.isEmpty(busiConditionList)){
			return;
		}
		
		for (InquiryBusiCondition inquiryBusiCondition : busiConditionList) {
			if (StringUtils.isBlank(inquiryBusiCondition.getId())) {
				inquiryBusiCondition.setId(UUIDGenerator.generateUUID());
			}
		}
		
		this.inquiryBusiConditionMapper.insertBatch(busiConditionList);
		
		PropertyValueUtils.addPropertyValue(busiConditionList, PropertyDefTplType.BUSI_TYPE.getCode());
	}
}