package com.els.base.inquiry.service.impl;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquiryQuoteLadderMapper;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultInquiryQuoteLadderService")
public class InquiryQuoteLadderServiceImpl implements InquiryQuoteLadderService {
    @Resource
    protected InquiryQuoteLadderMapper inquiryQuoteLadderMapper;

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    @Override
    public void addObj(InquiryQuoteLadder t) {
        this.inquiryQuoteLadderMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.inquiryQuoteLadderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    @Override
    public void modifyObj(InquiryQuoteLadder t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.inquiryQuoteLadderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="inquiryQuoteLadder", keyGenerator="redisKeyGenerator")
    @Override
    public InquiryQuoteLadder queryObjById(String id) {
        return this.inquiryQuoteLadderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="inquiryQuoteLadder", keyGenerator="redisKeyGenerator")
    @Override
    public List<InquiryQuoteLadder> queryAllObjByExample(InquiryQuoteLadderExample example) {
        return this.inquiryQuoteLadderMapper.selectByExample(example);
    }

    @Cacheable(value="inquiryQuoteLadder", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<InquiryQuoteLadder> queryObjByPage(InquiryQuoteLadderExample example) {
        PageView<InquiryQuoteLadder> pageView = example.getPageView();
        pageView.setQueryResult(this.inquiryQuoteLadderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
	@Override
	public void deleteByExample(InquiryQuoteLadderExample example) {
    	if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
			return;
		}
    	this.inquiryQuoteLadderMapper.deleteByExample(example);
	}
    
    @Cacheable(value="inquiryQuoteLadder", keyGenerator="redisKeyGenerator")
	@Override
	public BigDecimal queryLowestPriceForItem(String itemId) {
		InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
		example.createCriteria().andItemIdEqualTo(itemId);
		example.setOrderByClause("UNTAXED_UNIT_PRICE ASC");
		
		List<InquiryQuoteLadder> list = this.queryAllObjByExample(example);
		if (CollectionUtils.isEmpty(list)) {
			return BigDecimal.ZERO;
		}
		
		return list.get(0).getUntaxedUnitPrice();
	}

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
	@Override
	public void addAll(List<InquiryQuoteLadder> inquiryQuoteLadderList) {
    	if (CollectionUtils.isEmpty(inquiryQuoteLadderList)) {
			return;
		}
    	
    	inquiryQuoteLadderList.forEach(ladderPrice->{
    		if (StringUtils.isBlank(ladderPrice.getId())) ladderPrice.setId(UUIDGenerator.generateUUID());
    	});
		this.inquiryQuoteLadderMapper.insertBatch(inquiryQuoteLadderList);
	}

    @Cacheable(value="inquiryQuoteLadder", keyGenerator="redisKeyGenerator")
	@Override
	public List<InquiryQuoteLadder> queryByTargetId(String targetId) {
		InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
		example.createCriteria()
			.andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_TARGET.getCode())
			.andTargetIdEqualTo(targetId);
		return this.inquiryQuoteLadderMapper.selectByExample(example);
	}

    @Cacheable(value="inquiryQuoteLadder", keyGenerator="redisKeyGenerator")
	@Override
	public List<InquiryQuoteLadder> queryByOrderItemId(String itemId) {
    	InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
    	example.setOrderByClause("NUMBER_FROM ASC");
    	example.createCriteria().andItemIdEqualTo(itemId);
		return this.inquiryQuoteLadderMapper.selectByExample(example);
	}

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
	@Override
	public void modifyByExample(InquiryQuoteLadder t, InquiryQuoteLadderExample example) {
		this.inquiryQuoteLadderMapper.updateByExampleSelective(t, example);
	}

}