package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquirySupFileMapper;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.service.InquirySupFileService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultInquirySupFileService")
public class InquirySupFileServiceImpl implements InquirySupFileService {
    @Resource
    protected InquirySupFileMapper inquirySupFileMapper;

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    @Override
    public void addObj(InquirySupFile t) {
        this.inquirySupFileMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.inquirySupFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    @Override
    public void modifyObj(InquirySupFile t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.inquirySupFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="inquirySupFile", keyGenerator="redisKeyGenerator")
    @Override
    public InquirySupFile queryObjById(String id) {
        return this.inquirySupFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="inquirySupFile", keyGenerator="redisKeyGenerator")
    @Override
    public List<InquirySupFile> queryAllObjByExample(InquirySupFileExample example) {
        return this.inquirySupFileMapper.selectByExample(example);
    }

    @Cacheable(value="inquirySupFile", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<InquirySupFile> queryObjByPage(InquirySupFileExample example) {
        PageView<InquirySupFile> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
	@Override
	public void deleteByExample(InquirySupFileExample example) {
		if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
			return;
		}
		this.inquirySupFileMapper.deleteByExample(example);
	}

    @Transactional
    @CacheEvict(value={"inquirySupFile"}, allEntries=true)
    @Override
    public void addAll(List<InquirySupFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.inquirySupFileMapper.insertSelective(item);
            }
        });
        
    }
}