package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquirySupOrderMapper;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultInquirySupOrderService")
public class InquirySupOrderServiceImpl implements InquirySupOrderService {
    @Resource
    protected InquirySupOrderMapper inquirySupOrderMapper;

    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    @Override
    public void addObj(InquirySupOrder t) {
        this.inquirySupOrderMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.inquirySupOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
    @Override
    public void modifyObj(InquirySupOrder t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.inquirySupOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="inquirySupOrder", keyGenerator="redisKeyGenerator")
    @Override
    public InquirySupOrder queryObjById(String id) {
        return this.inquirySupOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="inquirySupOrder", keyGenerator="redisKeyGenerator")
    @Override
    public List<InquirySupOrder> queryAllObjByExample(InquirySupOrderExample example) {
        return this.inquirySupOrderMapper.selectByExample(example);
    }

    @Cacheable(value="inquirySupOrder", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<InquirySupOrder> queryObjByPage(InquirySupOrderExample example) {
        PageView<InquirySupOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    /*@CacheEvict(value={"inquirySupOrder"}, allEntries=true)
	@Override
	public List<InquirySupOrder> batchInsertObj(PurOrder order) {
		List<InquirySupplier> inquirySuppliers = order.getInquirySuppliers();
		List<InquirySupOrder> inquirySupOrders = null;
		if (CollectionUtils.isNotEmpty(inquirySuppliers)) {
			inquirySupOrders = new ArrayList<>();
			for (InquirySupplier inquirySupplier : inquirySuppliers) {
				InquirySupOrder inquirySupOrder = new InquirySupOrder();
				inquirySupOrder.setId(UUIDGenerator.generateUUID());
				inquirySupOrder.setType(order.getType());
				inquirySupOrder.setTemplateId(order.getTemplateId());
				inquirySupOrder.setPurOrderId(order.getId());
				inquirySupOrder.setSupCompanySrmCode(inquirySupplier.getSupSrmCode());
				inquirySupOrder.setSupCompanyId(inquirySupplier.getSupCompanyId());
				inquirySupOrder.setSupCompanyName(inquirySupplier.getSupCompanyName());
				inquirySupOrder.setSupCompanySapCode(inquirySupplier.getSupSapCode());
				inquirySupOrder.setSupUserId(null);//TODO
				inquirySupOrder.setSupUserName(null);//TODO
				inquirySupOrder.setOrderNo(order.getOrderNo());
				inquirySupOrder.setDigestExplain(order.getDigestExplain());
				inquirySupOrder.setCreateDate(order.getCreateDate());
				inquirySupOrder.setPublishDate(order.getPublishDate());
				inquirySupOrder.setQuoteStartDate(order.getQuoteStartDate());
				inquirySupOrder.setQuoteEndDate(order.getQuoteEndDate());
				inquirySupOrder.setRemark(order.getRemark());
				inquirySupOrder.setPurCompanyId(order.getPurCompanyId());
				inquirySupOrder.setPurCompanyName(order.getPurCompanyName());
				inquirySupOrder.setPurUserId(order.getPurUserId());
				inquirySupOrder.setPurUserName(order.getPurUserName());
				this.inquirySupOrderMapper.insertSelective(inquirySupOrder);
				inquirySupOrders.add(inquirySupOrder);
			}
		}
		return inquirySupOrders;
	}*/

    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
	@Override
	public void deleteByExample(InquirySupOrderExample example) {
    	if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
			return;
		}
		this.inquirySupOrderMapper.deleteByExample(example);
	}

//    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
//	@Override
//	public void cancelAllSupOrders(List<String> ids) {
//    	if (CollectionUtils.isEmpty(ids)) return;
//		
//		InquirySupOrder temp = new InquirySupOrder();
//		temp.setInquiryOrderStatus(InquiryPurOrderStatus.INVALID.getCode());
//		
//		InquirySupOrderExample example = new InquirySupOrderExample();
//		example.createCriteria().andIdIn(ids);
//		
//		this.inquirySupOrderMapper.updateByExampleSelective(temp, example);
//		
//	}

    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
	@Override
	public void addAll(List<InquirySupOrder> supOrderList) {
		if (CollectionUtils.isEmpty(supOrderList)) return;
		
		for (InquirySupOrder inquirySupOrder : supOrderList) {
			if (StringUtils.isBlank(inquirySupOrder.getId())) {
				inquirySupOrder.setId(UUIDGenerator.generateUUID());
			}
		}
		
		this.inquirySupOrderMapper.insertBatch(supOrderList);
	}

    @CacheEvict(value={"inquirySupOrder"}, allEntries=true)
	@Override
	public void modifyByExample(InquirySupOrder supOrder, InquirySupOrderExample supOrderExample) {
		this.inquirySupOrderMapper.updateByExampleSelective(supOrder, supOrderExample);
	}

    @Override
    public int countByExample(InquirySupOrderExample example) {
        return inquirySupOrderMapper.countByExample(example);
    }

}