package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.InquirySupReadMapper;
import com.els.base.inquiry.entity.InquirySupRead;
import com.els.base.inquiry.entity.InquirySupReadExample;
import com.els.base.inquiry.service.InquirySupReadService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultInquirySupReadService")
public class InquirySupReadServiceImpl implements InquirySupReadService {
    @Resource
    protected InquirySupReadMapper inquirySupReadMapper;

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    @Override
    public void addObj(InquirySupRead t) {
        this.inquirySupReadMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    @Override
    public void addAll(List<InquirySupRead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.inquirySupReadMapper.insertBatch(list);
    }

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.inquirySupReadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    @Override
    public void modifyObj(InquirySupRead t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.inquirySupReadMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="inquirySupRead", keyGenerator="redisKeyGenerator")
    @Override
    public InquirySupRead queryObjById(String id) {
        return this.inquirySupReadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="inquirySupRead", keyGenerator="redisKeyGenerator")
    @Override
    public List<InquirySupRead> queryAllObjByExample(InquirySupReadExample example) {
        return this.inquirySupReadMapper.selectByExample(example);
    }

    @Cacheable(value="inquirySupRead", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<InquirySupRead> queryObjByPage(InquirySupReadExample example) {
        PageView<InquirySupRead> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupReadMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"inquirySupRead"}, allEntries=true)
    @Override
    public void deleteByExample(InquirySupReadExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.inquirySupReadMapper.deleteByExample(arg0);
        
    }
}