package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.MaterielParityMapper;
import com.els.base.inquiry.entity.MaterielParity;
import com.els.base.inquiry.entity.MaterielParityExample;
import com.els.base.inquiry.service.MaterielParityService;
import com.els.base.inquiry.web.vo.MaterielParityVo;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultMaterielParityService")
public class MaterielParityServiceImpl implements MaterielParityService {
    @Resource
    protected MaterielParityMapper materielParityMapper;

    @CacheEvict(value={"materielParity"}, allEntries=true)
    @Override
    public void addObj(MaterielParity t) {
        this.materielParityMapper.insertSelective(t);
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.materielParityMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
    @Override
    public void modifyObj(MaterielParity t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.materielParityMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="materielParity", keyGenerator="redisKeyGenerator")
    @Override
    public MaterielParity queryObjById(String id) {
        return this.materielParityMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="materielParity", keyGenerator="redisKeyGenerator")
    @Override
    public List<MaterielParity> queryAllObjByExample(MaterielParityExample example) {
        return this.materielParityMapper.selectByExample(example);
    }

    @Cacheable(value="materielParity", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<MaterielParity> queryObjByPage(MaterielParityExample example) {
        PageView<MaterielParity> pageView = example.getPageView();
        pageView.setQueryResult(this.materielParityMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
	@Override
	public void batchModify(MaterielParityVo materielParityVo) {
    	String orderItemId = materielParityVo.getOrderItemId();
    	if (StringUtils.isBlank(orderItemId)) {
    		throw new CommonException("行项目id不能为空");
    	}
		// 根据行项目id删除所有同类物料参考比价
    	MaterielParityExample example = new MaterielParityExample();
    	example.createCriteria().andOrderItemIdEqualTo(orderItemId);
    	this.materielParityMapper.deleteByExample(example);
    	// 新增同类物料参考比价
    	if (!CollectionUtils.isEmpty(materielParityVo.getMaterielParitys())) {
    		materielParityVo.getMaterielParitys().forEach(materielParity -> {
    			materielParity.setOrderItemId(orderItemId);
    			this.addObj(materielParity);
    		});
    	}
	}

    @Transactional
    @CacheEvict(value={"materielParity"}, allEntries=true)
    @Override
    public void addAll(List<MaterielParity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.materielParityMapper.insertSelective(item);
            }
        });
        
    }

    @CacheEvict(value={"materielParity"}, allEntries=true)
    @Override
    public void deleteByExample(MaterielParityExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.materielParityMapper.deleteByExample(arg0);
        
    }
}