package com.els.base.inquiry.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.dao.MouldDetailMapper;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.MouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.MouldDetailService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultMouldDetailService")
public class MouldDetailServiceImpl implements MouldDetailService {
    @Resource
    protected MouldDetailMapper mouldDetailMapper;

    @Transactional
    @CacheEvict(value={"mouldDetail"}, allEntries=true)
    @Override
    public void addObj(MouldDetail t) {
        this.mouldDetailMapper.insertSelective(t);
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
    }

    @Transactional
    @CacheEvict(value={"mouldDetail"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
    	PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        this.mouldDetailMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mouldDetail"}, allEntries=true)
    @Override
    public void modifyObj(MouldDetail t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.mouldDetailMapper.updateByPrimaryKeySelective(t);
        
        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
    }

    @Cacheable(value="mouldDetail", keyGenerator="redisKeyGenerator")
    @Override
    public MouldDetail queryObjById(String id) {
        MouldDetail mouldDetail = this.mouldDetailMapper.selectByPrimaryKey(id);
        
        PropertyValueUtils.queryAndSetValue(Arrays.asList(mouldDetail),PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        return mouldDetail;
    }

    @Cacheable(value="mouldDetail", keyGenerator="redisKeyGenerator")
    @Override
    public List<MouldDetail> queryAllObjByExample(MouldDetailExample example) {
    	List<MouldDetail> list = this.mouldDetailMapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        return list;
    }

    @Cacheable(value="mouldDetail", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<MouldDetail> queryObjByPage(MouldDetailExample example) {
    	
        PageView<MouldDetail> pageView = example.getPageView();
        List<MouldDetail> list = this.mouldDetailMapper.selectByExampleByPage(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        
        pageView.setQueryResult(list);
        return pageView;
    }

    @Cacheable(value="mouldDetail", keyGenerator="redisKeyGenerator")
	@Override
	public IMouldDetail queryByMouldId(String mouldId) {
    	MouldDetailExample example = new MouldDetailExample();
    	example.createCriteria().andMouldIdEqualTo(mouldId);
    	example.setOrderByClause("ID ASC");
    	
    	List<MouldDetail> list = this.mouldDetailMapper.selectByExample(example);
    	if (CollectionUtils.isEmpty(list)) {
			return null;
		}
    	
    	PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
		return list.get(0);
	}

    @Transactional
    @CacheEvict(value={"mouldDetail"}, allEntries=true)
	@Override
	public void deleteByMouldIdList(List<String> mouldIdList) {
		if (CollectionUtils.isEmpty(mouldIdList)) {
			return;
		}
		
		MouldDetailExample example = new MouldDetailExample();
		example.createCriteria().andMouldIdIn(mouldIdList);
		List<MouldDetail> mouldDetailList = this.mouldDetailMapper.selectByExample(example);
		List<String> mouldDetailIdList = mouldDetailList.stream().map(MouldDetail::getId).collect(Collectors.toList());
		
		this.mouldDetailMapper.deleteByExample(example);
		PropertyValueUtils.deleteByExtenable(mouldDetailIdList, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
	}

    @Transactional
    @CacheEvict(value={"mouldDetail"}, allEntries=true)
	@Override
	public void addAll(List<MouldDetail> detailList) {
    	if (CollectionUtils.isEmpty(detailList)) {
			return;
		}
    	
    	Date now = new Date();
//		List<MouldDetail> mouldDetaiList = detailList.stream().map(detail-> (MouldDetail) detail).collect(Collectors.toList());
		detailList.forEach(mouldDetail->{
			if (StringUtils.isBlank(mouldDetail.getId())) {
				mouldDetail.setId(UUIDGenerator.generateUUID());
			}
			if (mouldDetail.getCreateTime() == null) {
				mouldDetail.setCreateTime(now);
			}
			mouldDetail.setUpdateTime(now);
		});
		
		this.mouldDetailMapper.insertBatch(detailList);
		
		PropertyValueUtils.addPropertyValue(detailList, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
	}

    @CacheEvict(value={"mouldDetail"}, allEntries=true)
    @Override
    public void deleteByExample(MouldDetailExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.mouldDetailMapper.deleteByExample(arg0);
        
    }
}