package com.els.base.inquiry.service.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.PropertyValueMapper;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PropertyValueExample;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultPropertyValueService")
public class PropertyValueServiceImpl implements PropertyValueService {
    @Resource
    protected PropertyValueMapper propertyValueMapper;

    @CacheEvict(value={"propertyValue"}, allEntries=true)
    @Override
    public void addObj(PropertyValue t) {
    	Assert.isNotBlank(t.getCode(), "字段编码不能为空");
    	Assert.isNotBlank(t.getType(), "字段类型不能为空");
        this.propertyValueMapper.insertSelective(t);
    }

    @CacheEvict(value={"propertyValue"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.propertyValueMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"propertyValue"}, allEntries=true)
    @Override
    public void modifyObj(PropertyValue t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.propertyValueMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="propertyValue", keyGenerator="redisKeyGenerator")
    @Override
    public PropertyValue queryObjById(String id) {
        return this.propertyValueMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="propertyValue", keyGenerator="redisKeyGenerator")
    @Override
    public List<PropertyValue> queryAllObjByExample(PropertyValueExample example) {
        return this.propertyValueMapper.selectByExample(example);
    }

    @Cacheable(value="propertyValue", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<PropertyValue> queryObjByPage(PropertyValueExample example) {
        PageView<PropertyValue> pageView = example.getPageView();
        pageView.setQueryResult(this.propertyValueMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="propertyValue", keyGenerator="redisKeyGenerator")
	@Override
	public boolean isContainTpl(String tplId, String propertyDefTplTypeCode) {
    	PropertyValueExample example = new PropertyValueExample();
    	example.createCriteria()
    		.andTplIdEqualTo(tplId)
    		.andTplTypeEqualTo(propertyDefTplTypeCode);
		return this.propertyValueMapper.countByExample(example) > 0;
	}

    @CacheEvict(value={"propertyValue"}, allEntries=true)
	@Override
	public void addAll(List<PropertyValue> propertyValueList) {
    	if (CollectionUtils.isEmpty(propertyValueList)) return;
    	
    	propertyValueList.forEach(propertyValue->{
    		if (StringUtils.isBlank(propertyValue.getId())) propertyValue.setId(UUIDGenerator.generateUUID());
    	});
    	
		this.propertyValueMapper.insertBatch(propertyValueList);
	}

    @CacheEvict(value={"propertyValue"}, allEntries=true)
	@Override
	public void deleteByExample(PropertyValueExample propertyValueExample) {
		this.propertyValueMapper.deleteByExample(propertyValueExample);
	}
}