package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.SystemPriceMapper;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.SystemPriceExample;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultSystemPriceService")
public class SystemPriceServiceImpl implements SystemPriceService {
    @Resource
    protected SystemPriceMapper systemPriceMapper;

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    @Override
    public void addObj(SystemPrice t) {
    	Assert.isNotNull(t, "要保存的参数为空");
        this.systemPriceMapper.insertSelective(t);
    }

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.systemPriceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    @Override
    public void modifyObj(SystemPrice t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.systemPriceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="systemPrice", keyGenerator="redisKeyGenerator")
    @Override
    public SystemPrice queryObjById(String id) {
        return this.systemPriceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="systemPrice", keyGenerator="redisKeyGenerator")
    @Override
    public List<SystemPrice> queryAllObjByExample(SystemPriceExample example) {
        return this.systemPriceMapper.selectByExample(example);
    }

    @Cacheable(value="systemPrice", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<SystemPrice> queryObjByPage(SystemPriceExample example) {
        PageView<SystemPrice> pageView = example.getPageView();
        pageView.setQueryResult(this.systemPriceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="systemPrice", keyGenerator="redisKeyGenerator")
	@Override
	public SystemPrice queryByMaterialAndSupCompany(String materialCode, String companySapCode) {
		if (StringUtils.isBlank(materialCode) || StringUtils.isBlank(companySapCode)) {
			return null;
		}
		
		SystemPriceExample example = new SystemPriceExample();
		example.createCriteria()
			.andMaterialCodeEqualTo(materialCode)
			.andCompanySapCodeEqualTo(companySapCode);
		
		example.setOrderByClause("CREATE_TIME DESC");
		
		List<SystemPrice> list = this.systemPriceMapper.selectByExample(example);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		return list.get(0);
	}

    @Transactional
    @CacheEvict(value={"systemPrice"}, allEntries=true)
    @Override
    public void addAll(List<SystemPrice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.systemPriceMapper.insertSelective(item);
            }
        });
        
    }

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    @Override
    public void deleteByExample(SystemPriceExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.systemPriceMapper.deleteByExample(arg0);
        
    }
}