package com.els.base.inquiry.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.dao.TargetM001Mapper;
import com.els.base.inquiry.entity.TargetM001;
import com.els.base.inquiry.entity.TargetM001Example;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.inquiry.service.TargetM001Service;
import com.els.base.inquiry.utils.PropertyValueUtils;

@Service("defaultTargetM001Service")
public class TargetM001ServiceImpl implements TargetM001Service {
    @Resource
    protected TargetM001Mapper targetM001Mapper;
    
    @Resource
    private InquiryQuoteLadderService quoteLadderService;
    
    @Resource
    private PropertyValueService propertyValueService;

    @Transactional
    @CacheEvict(value={"targetM001"}, allEntries=true)
    @Override
    public void addObj(TargetM001 t) {
        this.targetM001Mapper.insertSelective(t);
        
        List<TargetM001> targetList = new ArrayList<>();
        targetList.add(t);
        PropertyValueUtils.addPropertyValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
    }

    @Transactional
    @CacheEvict(value={"targetM001"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.targetM001Mapper.deleteByPrimaryKey(id);
        
        PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.TARGET_TYPE.getCode());
    }

    @Transactional
    @CacheEvict(value={"targetM001"}, allEntries=true)
    @Override
    public void modifyObj(TargetM001 t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.targetM001Mapper.updateByPrimaryKeySelective(t);

        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.TARGET_TYPE.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.TARGET_TYPE.getCode());
    }

    @Cacheable(value="targetM001", keyGenerator="redisKeyGenerator")
    @Override
    public TargetM001 queryObjById(String id) {
        TargetM001 target = this.targetM001Mapper.selectByPrimaryKey(id);
        if (target == null) {
			return target;
		}
        
        PropertyValueUtils.queryAndSetValue(Arrays.asList(target), PropertyDefTplType.TARGET_TYPE.getCode());
        return target;
    }

    @Cacheable(value="targetM001", keyGenerator="redisKeyGenerator")
    @Override
    public List<TargetM001> queryAllObjByExample(TargetM001Example example) {
        List<TargetM001> targetList = this.targetM001Mapper.selectByExample(example);
        
        PropertyValueUtils.queryAndSetValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
        return targetList;
    }

    @Cacheable(value="targetM001", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<TargetM001> queryObjByPage(TargetM001Example example) {
        PageView<TargetM001> pageView = example.getPageView();
        List<TargetM001> targetList = this.targetM001Mapper.selectByExampleByPage(example);
        
        PropertyValueUtils.queryAndSetValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
        pageView.setQueryResult(targetList);
        return pageView;
    }
    
    @Cacheable(value="targetM001", keyGenerator="redisKeyGenerator")
	@Override
	public List<ITarget> queryByPurOrderId(String purOrderId) {
		TargetM001Example example = new TargetM001Example();
		example.createCriteria().andPurOrderIdEqualTo(purOrderId);
		List<TargetM001> list = this.queryAllObjByExample(example);
		
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		
		List<ITarget> targetList = new ArrayList<>();
		targetList.addAll(list);
		
		PropertyValueUtils.queryAndSetValue(targetList, PropertyDefTplType.TARGET_TYPE.getCode());
		return targetList;
	}

	@Transactional
	@CacheEvict(value={"targetM001"}, allEntries=true)
	@Override
	public void addAll(List<TargetM001> targetList) {
		if (CollectionUtils.isEmpty(targetList)) {
			return;
		}
		
		List<TargetM001> targetM001List = targetList.stream()
			.map(target->{
				return (TargetM001)target;
			}).collect(Collectors.toList());
		
		for(TargetM001 targetM001 : targetM001List) {
			this.addObj(targetM001);
		}
		
	}
	
	
	@Transactional
	@CacheEvict(value={"targetM001"}, allEntries=true)
	@Override
	public void deleteObjByPurOrderId(String purOrderId) {
		TargetM001Example example = new TargetM001Example();
		example.createCriteria().andPurOrderIdEqualTo(purOrderId);
		
		List<TargetM001> targetList = this.queryAllObjByExample(example);
		List<String> targetIdList = targetList.stream().map(TargetM001::getId).collect(Collectors.toList());
		
		PropertyValueUtils.deleteByExtenable(targetIdList, PropertyDefTplType.TARGET_TYPE.getCode());
		
		// 根据询价单id删除物料清单
		targetM001Mapper.deleteByExample(example);
		
	}

	@CacheEvict(value={"targetM001"}, allEntries=true)
        @Override
        public void deleteByExample(TargetM001Example arg0) {
	    Assert.isNotNull(arg0, "参数不能为空");
	        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
	        this.targetM001Mapper.deleteByExample(arg0);
            
        }

}