package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.dao.TemplateConfMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultTemplateConfService")
public class TemplateConfServiceImpl implements TemplateConfService {
    @Resource
    protected TemplateConfMapper templateConfMapper;
    
    @Resource
    protected PropertyDefService propertyDefService;
    
    @Resource
    protected TplMouldDetailService tplMouLdDetailService;
    
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;

    @CacheEvict(value={"templateConf"}, allEntries=true)
    @Override
    public void addObj(TemplateConf t) {
    	Assert.isNotBlank(t.getCode(), "编码不能为空");
    	TemplateConfExample example = new TemplateConfExample();
    	example.createCriteria()
    		.andCodeEqualTo(t.getCode())
    		.andIsHisEqualTo(Constant.NO_INT);
    	if (this.templateConfMapper.countByExample(example) > 0) {
			throw new CommonException("编码已存在");
		}
        this.templateConfMapper.insertSelective(t);
    }

    @CacheEvict(value={"templateConf"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
    	this.templateConfMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"templateConf"}, allEntries=true)
    @Override
    public void modifyObj(TemplateConf t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        
        if (t.getCode() == null) {
        	this.templateConfMapper.updateByPrimaryKeySelective(t);
        	return;
		}
        
        TemplateConfExample example = new TemplateConfExample();
        example.createCriteria()
        	.andCodeEqualTo(t.getCode())
        	.andIdNotEqualTo(t.getId())
        	.andIsHisEqualTo(Constant.NO_INT);
        
        if (this.templateConfMapper.countByExample(example) > 0) {
			throw new CommonException("编码已存在");
		}
        
        this.templateConfMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="templateConf", keyGenerator="redisKeyGenerator")
    @Override
    public TemplateConf queryObjById(String id) {
    	TemplateConf templateConf = this.templateConfMapper.selectByPrimaryKey(id);
    	Assert.isNotNull(templateConf, "模板不存在，请刷新重试");
    	
    	if (!Constant.YES_INT.equals(templateConf.getIsHis())) {
			return initData(templateConf);
		}else{
			return initHisData(templateConf);
		}
    }
    
    private TemplateConf initHisData(TemplateConf templateConf) {
    	
    	List<PropertyDef> itemProDefList = this.propertyDefService.queryHisPropertyDefList(templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
    	templateConf.setOrderItemPropertyDefList(itemProDefList);
    	
    	if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
    		List<PropertyDef> mouldProDefList = this.propertyDefService.queryHisPropertyDefList(templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
    		templateConf.setMouldPropertyDefList(mouldProDefList);
		}
    	if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
    		List<PropertyDef> busProDefList = this.propertyDefService.queryHisPropertyDefList(templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
    		templateConf.setBusiConditionPropertyDefList(busProDefList);
		}
    	if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())
    			&& StringUtils.isNotBlank(templateConf.getMouldItemDtlTplId())) {
    		templateConf.setTplMouLdDetail(this.tplMouLdDetailService.queryObjById(templateConf.getMouldItemDtlTplId()));
		}
    	if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())
    			&& StringUtils.isNotBlank(templateConf.getOrderItemDtlTplId())) {
			templateConf.setTplOrderItemDetail(this.tplOrderItemDetailService.queryObjById(templateConf.getOrderItemDtlTplId()));
		}
    	
        return templateConf;
	}

	private TemplateConf initData(TemplateConf templateConf){
    	templateConf.setOrderItemPropertyDefList(PropertyDefUtils.queryOrderItemProDef(templateConf));
    	
    	if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
    		templateConf.setMouldPropertyDefList(PropertyDefUtils.queryMouldProDef(templateConf));
		}
    	if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
    		templateConf.setBusiConditionPropertyDefList(PropertyDefUtils.queryBusiConditionProDef(templateConf));
		}
    	if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())
    			&& StringUtils.isNotBlank(templateConf.getMouldItemDtlTplId())) {
    		templateConf.setTplMouLdDetail(this.tplMouLdDetailService.queryObjById(templateConf.getMouldItemDtlTplId()));
		}
    	if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())
    			&& StringUtils.isNotBlank(templateConf.getOrderItemDtlTplId())) {
			templateConf.setTplOrderItemDetail(this.tplOrderItemDetailService.queryObjById(templateConf.getOrderItemDtlTplId()));
		}
    	
        return templateConf;
    }

    @Cacheable(value="templateConf", keyGenerator="redisKeyGenerator")
    @Override
    public List<TemplateConf> queryAllObjByExample(TemplateConfExample example) {
        return this.templateConfMapper.selectByExample(example);
    }

    @Cacheable(value="templateConf", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<TemplateConf> queryObjByPage(TemplateConfExample example) {
        PageView<TemplateConf> pageView = example.getPageView();
        pageView.setQueryResult(this.templateConfMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"templateConf"}, allEntries=true)
    @Override
    public void addAll(List<TemplateConf> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.templateConfMapper.insertSelective(item);
            }
        });
        
    }

    @CacheEvict(value={"templateConf"}, allEntries=true)
    @Override
    public void deleteByExample(TemplateConfExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.templateConfMapper.deleteByExample(arg0);
        
    }
}