package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.dao.TplMouldDetailMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultTplMouldDetailService")
public class TplMouldDetailServiceImpl implements TplMouldDetailService {
    @Resource
    protected TplMouldDetailMapper tplMouldDetailMapper;
    
    @Resource
    protected PropertyDefService propertyDefService;

    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    @Override
    public void addObj(TplMouldDetail t) {
    	Assert.isNotBlank(t.getCode(), "编码不能为空");
    	
    	TplMouldDetailExample example = new TplMouldDetailExample();
    	example.createCriteria()
    		.andCodeEqualTo(t.getCode())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	if (this.tplMouldDetailMapper.countByExample(example) > 0) {
			throw new CommonException("编码已存在");
		}
    	
        this.tplMouldDetailMapper.insertSelective(t);

    }

    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
//    	TplMouldDetail temp = new TplMouldDetail();
//    	temp.setIsHis(Constant.YES_INT);
//    	temp.setId(id);
//        this.tplMouldDetailMapper.updateByPrimaryKeySelective(temp);
    	this.tplMouldDetailMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    @Override
    public void modifyObj(TplMouldDetail t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        
        if (t.getCode() != null) {
			
        	TplMouldDetailExample example = new TplMouldDetailExample();
        	example.createCriteria()
        		.andCodeEqualTo(t.getCode())
        		.andIdNotEqualTo(t.getId())
        		.andIsHisEqualTo(Constant.YES_INT);
        	
        	if (this.tplMouldDetailMapper.countByExample(example) > 0) {
        		throw new CommonException("编码已存在");
        	}
		}
        
        this.tplMouldDetailMapper.updateByPrimaryKeySelective(t);

    }

    @Cacheable(value="tplMouldDetail", keyGenerator="redisKeyGenerator")
    @Override
    public TplMouldDetail queryObjById(String id) {
    	TplMouldDetail tplMouLdDetail = this.tplMouldDetailMapper.selectByPrimaryKey(id);
    	if (tplMouLdDetail == null) {
			return tplMouLdDetail;
		}
    	
    	if (!Constant.YES_INT.equals(tplMouLdDetail.getIsHis())) {
    		tplMouLdDetail.setPropertyDefList(PropertyDefUtils.queryMouldDetailProDef(tplMouLdDetail));
			
		}else {
			List<PropertyDef> tplMouldProDefList = this.propertyDefService.queryHisPropertyDefList(id, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
			tplMouLdDetail.setPropertyDefList(tplMouldProDefList);
		}
    	
        return tplMouLdDetail;

    }

    @Cacheable(value="tplMouldDetail", keyGenerator="redisKeyGenerator")
    @Override
    public List<TplMouldDetail> queryAllObjByExample(TplMouldDetailExample example) {
        return this.tplMouldDetailMapper.selectByExample(example);
    }

    @Cacheable(value="tplMouldDetail", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<TplMouldDetail> queryObjByPage(TplMouldDetailExample example) {
        PageView<TplMouldDetail> pageView = example.getPageView();
        pageView.setQueryResult(this.tplMouldDetailMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    @Override
    public void addAll(List<TplMouldDetail> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.tplMouldDetailMapper.insertSelective(item);
            }
        });
        
    }

    @CacheEvict(value={"tplMouldDetail"}, allEntries=true)
    @Override
    public void deleteByExample(TplMouldDetailExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.tplMouldDetailMapper.deleteByExample(arg0);
        
    }
}