package com.els.base.inquiry.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.dao.TplOrderItemDetailMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultTplOrderItemDetailService")
public class TplOrderItemDetailServiceImpl implements TplOrderItemDetailService {
    @Resource
    protected TplOrderItemDetailMapper tplOrderItemDetailMapper;

    @Resource
    protected PropertyDefService propertyDefService;

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    @Override
    public void addObj(TplOrderItemDetail t) {
    	Assert.isNotBlank(t.getCode(), "编码不能为空");
    	
    	TplOrderItemDetailExample example = new TplOrderItemDetailExample();
    	example.createCriteria().andCodeEqualTo(t.getCode()).andIsHisEqualTo(Constant.NO_INT);
    	
    	if (this.tplOrderItemDetailMapper.countByExample(example) > 0) {
			throw new CommonException("编码已存在");
		}
    	
        this.tplOrderItemDetailMapper.insertSelective(t);
    }

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
//    	TplOrderItemDetail temp = new TplOrderItemDetail();
//    	temp.setId(id);
//    	temp.setIsHis(Constant.YES_INT);
//        this.tplOrderItemDetailMapper.updateByPrimaryKeySelective(temp);
    	this.tplOrderItemDetailMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    @Override
    public void modifyObj(TplOrderItemDetail t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        
        if (t.getCode() != null) {
			
        	TplOrderItemDetailExample example = new TplOrderItemDetailExample();
        	example.createCriteria().andCodeEqualTo(t.getCode()).andIdNotEqualTo(t.getId()).andIsHisEqualTo(Constant.NO_INT);
        	
        	if (this.tplOrderItemDetailMapper.countByExample(example) > 0) {
        		throw new CommonException("编码已存在");
        	}
		}
        
        this.tplOrderItemDetailMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="tplOrderItemDetail", keyGenerator="redisKeyGenerator")
    @Override
    public TplOrderItemDetail queryObjById(String id) {
    	
    	TplOrderItemDetail tplOrderItemDetail = this.tplOrderItemDetailMapper.selectByPrimaryKey(id);
    	if (tplOrderItemDetail == null) {
			return null;
		}
    	
    	if (!Constant.YES_INT.equals(tplOrderItemDetail.getIsHis())) {
    		tplOrderItemDetail.setPropertyDefList(PropertyDefUtils.queryOrderItemDetailProDef(tplOrderItemDetail));
			
		}else {
			List<PropertyDef> propertyDefList = propertyDefService.queryHisPropertyDefList(tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
			tplOrderItemDetail.setPropertyDefList(propertyDefList);
		}
    	
    	return tplOrderItemDetail;
    }

    @Cacheable(value="tplOrderItemDetail", keyGenerator="redisKeyGenerator")
    @Override
    public List<TplOrderItemDetail> queryAllObjByExample(TplOrderItemDetailExample example) {
        return this.tplOrderItemDetailMapper.selectByExample(example);
    }

    @Cacheable(value="tplOrderItemDetail", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<TplOrderItemDetail> queryObjByPage(TplOrderItemDetailExample example) {
        PageView<TplOrderItemDetail> pageView = example.getPageView();
        pageView.setQueryResult(this.tplOrderItemDetailMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    @Override
    public void addAll(List<TplOrderItemDetail> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.tplOrderItemDetailMapper.insertSelective(item);
            }
        });
        
    }

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    @Override
    public void deleteByExample(TplOrderItemDetailExample arg0) {
        Assert.isNotNull(arg0, "参数不能为空");
        Assert.isNotEmpty(arg0.getOredCriteria(), "批量删除不能全表删除");
        this.tplOrderItemDetailMapper.deleteByExample(arg0);
        
    }
}