package com.els.base.inquiry.utils;

import static java.util.stream.Collectors.toList;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;

public class ClassReflectionUtils {
	
	private ClassReflectionUtils() {
	}
	
	@SuppressWarnings("rawtypes")
	public static Class getClassByName(String className){
		Assert.isNotBlank(className, "模板配置异常，类名为空");
		
		try {
			return Class.forName(className);
		} catch (ClassNotFoundException e) {
			throw new CommonException(String.format("模板配置异常，找不到该类[%s]", className));
		}
	}

	public static <T> T newInstatnce(Class<T> orderItemClass) {
		try {
			return orderItemClass.newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			throw new CommonException(String.format("模板配置异常，该类初始化异常[%s]", orderItemClass.getName()));
		}
	}
	
	/**
	 * 获取所有class自带，有set方法的字段
	 * @return
	 */
	public static List<Field> getPrimitiveField(Class clazz){
		List<Field> fieldArray = getAllField(clazz);
		List<Method> methodArray = getAllMethod(clazz);
		
		return fieldArray.stream().filter(field->{
			String setMethodName = String.format("set%s", StringUtils.capitalize(field.getName()));
			
			return methodArray.stream().anyMatch(methodObj->{
				return setMethodName.equals(methodObj.getName());
			});
			
		}).collect(toList());
		
	}
	
	@SuppressWarnings("rawtypes")
	private static List<Method> getAllMethod(Class clazz){
		Method[] methodArray = clazz.getDeclaredMethods();
		
		Class supClass = clazz.getSuperclass();
		if (supClass == null) {
			return Arrays.asList(methodArray);
		}
		
		List<Method> supMethods = Arrays.stream(supClass.getDeclaredMethods()).filter(supMethodObj->{
			
			return Arrays.stream(methodArray).noneMatch(method->{
				return method.getName().equals(supMethodObj.getName());
			});
			
		}).collect(toList());
		
		supMethods.addAll(Arrays.asList(methodArray));
		return supMethods;
	}
	
	@SuppressWarnings("rawtypes")
	private static List<Field> getAllField(Class clazz){
		
		Field[] fieldArray = clazz.getDeclaredFields();
		
		Class supClass = clazz.getSuperclass();
		if (supClass == null) {
			return Arrays.asList(fieldArray);
		}
		
		List<Field> supFieldList = Arrays.stream(supClass.getDeclaredFields()).filter(supField->{
			
			return Arrays.stream(fieldArray).noneMatch(field->{
				return field.getName().equals(supField.getName());
			});
		}).collect(toList());
		
		supFieldList.addAll(Arrays.asList(fieldArray));
		return supFieldList;
	}
	

}
