package com.els.base.inquiry.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.ITargetService;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.utils.SpringContextHolder;

public class InquiryTemplateFactory  {
	
	public static InquiryTemplateFactory getInstance(String templateId){
		Assert.isNotBlank(templateId, "模板id不能为空");
		
		TemplateConfService service = SpringContextHolder.getOneBean(TemplateConfService.class);
		TemplateConf templateConf = service.queryObjById(templateId);
		
		Assert.isNotNull(templateConf, "模板配置数据不存在");
		Assert.isNotBlank(templateConf.getTargetClassName(), "模板配置数据不完整，缺少targetClass");
		Assert.isNotBlank(templateConf.getTargetServiceClassName(), "模板配置数据不完整，缺少targetService");
		Assert.isNotBlank(templateConf.getItemClassName(), "模板配置数据不完整，缺少itemClass");
		Assert.isNotBlank(templateConf.getItemServiceClassName(), "模板配置数据不完整，缺少itemService");
		
		return new InquiryTemplateFactory(templateConf);
	}
	
	private TemplateConf templateConf;
	
	private InquiryTemplateFactory(TemplateConf templateConf){
		super();
		this.templateConf = templateConf;
	}
	

	/*public ITarget getTarget(InquiryWaitMaterial waitMaterial) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
		Class<ITarget> clazz = getTargetClass();
		ITarget target = clazz.getConstructor().newInstance();
		target.buildFromWaitMaterial(waitMaterial);
		return target;
		
	}*/
	public <T extends ITarget> Class<T> getTargetClass() {
		try {
			return (Class<T>) Class.forName(this.templateConf.getTargetClassName());
		} catch (ClassNotFoundException e) {
			throw new CommonException(String.format("模板配置异常,不存在类[%s]", this.templateConf.getTargetClassName()), e);
		}
	}

	public <TS extends ITargetService> TS getTargetService() {
		try {
			Class<TS> clazz = (Class<TS>) Class.forName(this.templateConf.getTargetServiceClassName());
			return SpringContextHolder.getOneBean(clazz);
		} catch (ClassNotFoundException e) {
			throw new CommonException(String.format("模板配置异常,不存在类[%s]", this.templateConf.getTargetClassName()), e);
		}
		
	}

	public String getTargetName() {
		return "M001";
	}

	public <IT extends IOrderItem> Class<IT>  getItemClass() {
		try {
			return (Class<IT>) Class.forName(this.templateConf.getItemClassName());
		} catch (ClassNotFoundException e) {
			throw new CommonException(String.format("模板配置异常,不存在类[%s]", this.templateConf.getTargetClassName()), e);
		}
	}

	public <ITS extends IOrderItemService> ITS getItemService() {
		try {
			Class<ITS> clazz = (Class<ITS>) Class.forName(this.templateConf.getItemServiceClassName());
			return SpringContextHolder.getOneBean(clazz);
		} catch (ClassNotFoundException e) {
			throw new CommonException(String.format("模板配置异常,不存在类[%s]", this.templateConf.getTargetClassName()), e);
		}
	}

}
