package com.els.base.inquiry.utils;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.entity.InquiryQuoteLadder;

/**
 * 检验阶梯报价
 * @author lly
 */
public class LaddPriceValider {

    private LaddPriceValider() {
    	super();
    }

    public static void valid(List<InquiryQuoteLadder> inquiryQuoteLadders) {
    	if (CollectionUtils.isEmpty(inquiryQuoteLadders)) {
			return;
		}
    	
        inquiryQuoteLadders.sort((l1,l2)->{
            return l1.getNumberFrom().compareTo(l2.getNumberFrom());
        });
        inquiryQuoteLadders.stream().reduce((result, l1) -> {
            if (result == null) {
                return l1;
            }
            if (l1.getNumberFrom().compareTo(result.getNumberTo()) != 0) {
                throw new CommonException(String.format("阶梯设置异常：[%s] - [%s],  [%s] - [%s]", result.getNumberFrom(), result.getNumberTo(), l1.getNumberFrom(), l1.getNumberTo()));
            }
            if (l1.getNumberFrom().compareTo(result.getNumberTo()) != 0) {
                throw new CommonException(String.format("阶梯设置异常：[%s] - [%s],  [%s] - [%s]", result.getNumberFrom(), result.getNumberTo(), l1.getNumberFrom(), l1.getNumberTo()));
            }
            return l1;
        });

    }

}
