package com.els.base.inquiry.utils.excel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.excel.TitleAndModelKey;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelUtil {

	public static List<Map<String, String>> importExcelDataToMap(InputStream in, int sheetIndex, int dataStartRowIndex,
            int headRowIndex, List<TitleAndModelKey> titleAndModelKeys) throws Exception{
		if (CollectionUtils.isEmpty(titleAndModelKeys)) {
            throw new NullPointerException("export setting 'titleAndModelKeys' can not be null");
        }
		
		Workbook workbook = Workbook.getWorkbook(in);
        Sheet sheet = workbook.getSheet(sheetIndex);
        List<Map<String, String>> results = getAllRows(sheet, dataStartRowIndex, titleAndModelKeys);
		return results;
	}

	private static List<Map<String, String>> getAllRows(Sheet sheet, int dataStartRowIndex, List<TitleAndModelKey> titleAndModelKeys) {
		int rowNum = sheet.getRows();
		if (dataStartRowIndex >= rowNum) {
			throw new CommonException("您没有填写行数据");
		}
		List<Map<String,String>> results = new ArrayList<>(rowNum);
		int columnNum = titleAndModelKeys.size();
		int readIndex = dataStartRowIndex;
		while(readIndex < rowNum) {
			Map<String, String> map = new HashMap<>(columnNum);
			for (int i = 0; i < columnNum; i++) {
				Cell cell = sheet.getCell(i, readIndex);
				map.put(titleAndModelKeys.get(i).getModelKey(), cell.getContents());
			}
			results.add(map);
			readIndex++;
		}
		return results;
	}
	
}
