package com.els.base.inquiry.utils.json;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.utils.excel.ConverterFactory;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

public class DetailSerialzer<T extends IExtendable> extends JsonSerializer<T> {

	@Override
	public void serialize(T value, JsonGenerator gen, SerializerProvider serializers)
			throws IOException, JsonProcessingException {
		
		List<PropertyValue> propertyValues = this.getProperyValueClass(value);
		gen.writeObject(propertyValues);
	}
	
	public List<PropertyValue> getProperyValueClass(T value){
		if (value == null) {
			return null;
		}
		
		List<PropertyValue> proValueList = new ArrayList<>();
		proValueList.addAll(this.getPropertValueFormUnPrimitiveField(value));
		proValueList.addAll(this.getPropertValueFormPrimitiveField(value)) ;
		
		proValueList = removeDupliById(proValueList);
		proValueList = proValueList.stream()
			.filter(proVal -> proVal != null)
			.collect(Collectors.toList());
		
		proValueList.sort((p1, p2)->{
			if (p1 == null || p1.getSortNo() == null) return -1;
			if (p2 == null || p2.getSortNo() == null) return 1;
			
			return p1.getSortNo().compareTo(p2.getSortNo());
		});
		return proValueList;
	}
	
	public List<PropertyValue> removeDupliById(List<PropertyValue> proValueList) {
		if (CollectionUtils.isEmpty(proValueList)) {
			return proValueList;
		}
		
		Set<PropertyValue> personSet = new TreeSet<>((o1, o2) -> o1.getCode().compareTo(o2.getCode())); 
		personSet.addAll(proValueList); 
		return new ArrayList<>(personSet); 
	}
	
	private Collection<? extends PropertyValue> getPropertValueFormPrimitiveField(T value) {
		List<Field> fieldList = ClassReflectionUtils.getPrimitiveField(value.getClass());
		List<PropertyDef> defList = value.getPropertyDefList();
		
		List<PropertyDef> primitiveDef = defList.stream()
			.filter(def-> fieldList.stream().anyMatch(field-> field.getName().equals(def.getCode())))
			.collect(Collectors.toList());
		
		List<PropertyValue> primitiveValueList = primitiveDef.stream().map(def->{
			
			PropertyValue proValue = def.buildValue();
			proValue.setId(null);
			
			Object filedVauleObj = fieldList.stream()
				.filter(field-> field.getName().equals(def.getCode()))
				.findAny()
				.map(filed->ReflectUtils.getValue(value, filed.getName()))
				.orElseGet(()-> null);
			
			if (filedVauleObj == null) {
				proValue.setValueStr(null);
				return proValue;
			}
			
			ObjToStrConverter converter = ConverterFactory.getDefaultToStrConverter(filedVauleObj.getClass());
			if (converter != null) {
				proValue.setValueStr(converter.convert(filedVauleObj, null, 0));
				return proValue;
			}
			
			proValue.setValueStr(String.valueOf(filedVauleObj));
			return proValue;
		}).collect(Collectors.toList());
		
		if (primitiveValueList == null) {
			primitiveValueList = new ArrayList<>();
		}
		
		return primitiveValueList;
	}

	private Collection<? extends PropertyValue> getPropertValueFormUnPrimitiveField(T value) {
		List<Field> fieldList = ClassReflectionUtils.getPrimitiveField(value.getClass());
		List<PropertyDef> defList = value.getPropertyDefList();
		
		//筛选出所有自定义字段
		defList = defList.stream()
			.filter(def -> fieldList.stream().noneMatch(field-> field.getName().equals(def.getCode())))
			.collect(Collectors.toList());
		
		//查询自定义字段的数据值
		if (CollectionUtils.isEmpty(value.getPropertyValueList())) {
			value.setPropertyValueList(new ArrayList<>());
		}
		List<PropertyValue> proValueList = value.getPropertyValueList();
		
		//把有数据的自定义字段找出来
		List<PropertyValue> temp1 = defList.stream()
			.filter(def-> value.getPropertyValueList().stream().anyMatch(proVal-> def.getCode().equals(proVal.getCode())))
			.map(def -> {
				return value.getPropertyValueList().stream().filter(proVal-> def.getCode().equals(proVal.getCode())).findAny().get();
			}).collect(Collectors.toList());
		
		if (CollectionUtils.isNotEmpty(temp1)) {
			proValueList.addAll(temp1);
		}
		
		//把没有数据的自定义字段，生成值
		proValueList = proValueList.stream()
			.filter(proValue-> fieldList.stream().noneMatch(field-> field.getName().equals(proValue.getCode())))
			.collect(Collectors.toList());
		
		List<PropertyValue> temp2 = defList.stream()
			.filter(def-> value.getPropertyValueList().stream().noneMatch(proVal-> def.getCode().equals(proVal.getCode())))
			.map(PropertyDef::buildValue)
			.collect(Collectors.toList());
		
		if (CollectionUtils.isNotEmpty(temp2)) {
			proValueList.addAll(temp2);
		}
		
		return proValueList;
	}

}
