package com.els.base.inquiry.utils.json;

import java.io.IOException;
import java.lang.reflect.Field;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.entity.InquiryMould;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * 可自定义的对象的序列化
 * @author hzy
 *
 */
public class InquiryMouldJsonDeSerialzer extends ExtendableObjectJsonDeSerialzer<InquiryMould>{
	
	protected static final Logger logger = LoggerFactory.getLogger(InquiryMouldJsonDeSerialzer.class);
	private String mouldDetailJson = null;
	
	@Override
	public InquiryMould deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JsonProcessingException {
		InquiryMould instance = super.deserialize(p, ctxt);
		
		if (StringUtils.isBlank(this.mouldDetailJson)) {
			return instance;
		}
		logger.info(this.mouldDetailJson);
		
		if (StringUtils.isBlank(instance.getTemplateId())) {
			logger.warn("OrderItemM001.template == null ，无法解析物料成本清单");
			return instance;
		}
		
		IMouldDetail mouldDetail = null;
		try {
			mouldDetail = this.deserializeMouldDetail(this.mouldDetailJson, instance);
		} catch (InstantiationException | IllegalAccessException e) {
			throw new RuntimeException("参数解析失败",e);
		}
		
		if (mouldDetail != null) {
			mouldDetail.setMouldId(instance.getId());
		}
		instance.setMouldDetail(mouldDetail);
		return instance;
	}
	
	private IMouldDetail deserializeMouldDetail(String mouldDetailJson, InquiryMould instance) throws JsonParseException, JsonMappingException, InstantiationException, IllegalAccessException, IOException {
		TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(instance.getTemplateId());
		if (!Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())) {
			return null;
		}
		
		Class<? extends IMouldDetail> clazz = templateConf.getTplMouLdDetail().getMouldDetailClass();
		DetailDeSerializer<IMouldDetail> serializer = new DetailDeSerializer(clazz);
		
		IMouldDetail mouldDetail = serializer.serializer(mouldDetailJson);
		return mouldDetail;
	}

	@Override
	protected void setPrimitFieldValue(InquiryMould t, Field field, JsonNode jsonNode)
			throws Exception {
		if (jsonNode == null) {
			return;
		}
		
		if (field.getName().equals("mouldDetail")) {
			this.mouldDetailJson = jsonNode.toString();
			return;
		}
		
		super.setPrimitFieldValue(t, field, jsonNode);
	}

	@Override
	public Class<InquiryMould> getInstanceClass() {
		return InquiryMould.class;
	}

}
