package com.els.base.inquiry.utils.json;

import java.io.IOException;
import java.lang.reflect.Field;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * 可自定义的对象的序列化
 * @author hzy
 *
 */
public class OrderItemJsonDeSerialzer extends ExtendableObjectJsonDeSerialzer<OrderItemM001>{
	
	protected static final Logger logger = LoggerFactory.getLogger(OrderItemJsonDeSerialzer.class);
	private String itemDetailJson = null;
	
	@Override
	public OrderItemM001 deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JsonProcessingException {
		OrderItemM001 instance = super.deserialize(p, ctxt);
		
		if (StringUtils.isBlank(this.itemDetailJson)) {
			return instance;
		}
		
		if (StringUtils.isBlank(instance.getTemplateId())) {
			logger.warn("OrderItemM001.template == null ，无法解析物料成本清单");
			return instance;
		}
		
		IOrderItemDetail orderItemDetail = null;
		try {
			orderItemDetail = this.deserializeOrderItemDetail(this.itemDetailJson, instance);
		} catch (InstantiationException | IllegalAccessException e) {
			throw new RuntimeException("参数解析失败",e);
		}
		
		instance.setOrderItemDetail(orderItemDetail);
		return instance;
	}
	
	@Override
	protected void setPrimitFieldValue(OrderItemM001 t, Field field,  JsonNode jsonNode) throws Exception {
		if (jsonNode == null) {
			return;
		}
		
		if ("orderItemDetail".equals(field.getName())) {
			this.itemDetailJson = jsonNode.toString();
			return;
		}
		super.setPrimitFieldValue(t, field, jsonNode);
	}
	
	private IOrderItemDetail deserializeOrderItemDetail(String itemDetailJson, OrderItemM001 orderItem) throws JsonParseException, JsonMappingException, IOException, InstantiationException, IllegalAccessException {
		
		TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(orderItem.getTemplateId());
		if (!Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
			return null;
		}
		
		Class<? extends IOrderItemDetail> clazz = templateConf.getTplOrderItemDetail().getOrderItemDetailClass();
		DetailDeSerializer<IOrderItemDetail> serializer = new DetailDeSerializer(clazz);
		
		IOrderItemDetail instance = serializer.serializer(itemDetailJson);
		return instance;
	}
	
	@Override
	public Class<OrderItemM001> getInstanceClass() {
		return OrderItemM001.class;
	}

}
