package com.els.base.inquiry.utils.json;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.impl.TemplateConfServiceImpl;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class PurOrderJsonDeserialzer extends JsonDeserializer<PurOrder> {

	private String targetJson;
	
	private String itemsJson;
	
	private String mouldJson;
	
	private TemplateConf templateConf;
	
	@SuppressWarnings("unchecked")
	@Override
	public PurOrder deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		PurOrder order = new PurOrder();
		try {
			ObjectNode objectNode = p.readValueAsTree();
			Iterator<String> fieldNamesIterator = objectNode.fieldNames();
			while (fieldNamesIterator.hasNext()) {
				String fieldName = fieldNamesIterator.next();
				JsonNode value = objectNode.get(fieldName);
				if ("targetList".equals(fieldName)) {
					// 保存targetList的值，保证解析其值在读取templateId之后
					targetJson = value.toString();
					continue;
				}
				if ("itemList".equals(fieldName)) {
					// 保存itemList的值，保证解析其值在读取templateId之后
					itemsJson = value.toString();
					continue;
				}
				
				if ("mouldList".equals(fieldName)) {
					mouldJson = value.toString();
					continue;
				}
				
				if ("inquirySuppliers".equals(fieldName)) {
					// 供应商用户列表，特殊处理，转成List<InquirySupplier>类型
					List<InquirySupplier> inquirySuppliers = JsonUtils.convertCollection(value.toString(), List.class, null, InquirySupplier.class);
					order.setInquirySuppliers(inquirySuppliers);
					continue;
				}
				if ("purFileList".equals(fieldName)) {
					// 采购方文件列表，特殊处理，转成List<InquiryPurFile>类型
					List<InquiryPurFile> inquiryPurFiles = JsonUtils.convertCollection(value.toString(), List.class, null, InquiryPurFile.class);
					order.setPurFileList(inquiryPurFiles);
					continue;
				}
				if ("supFileList".equals(fieldName)) {
					// 供应商文件列表，特殊处理，转成List<InquirySupFile>类型
					List<InquirySupFile> inquirySupFiles = JsonUtils.convertCollection(value.toString(), List.class, null, InquirySupFile.class);
					order.setSupFileList(inquirySupFiles);
					continue;
				}
				if ("busiConditions".equals(fieldName)) {
					// 商务条件列表，特殊处理，转成List<InquiryBusiCondition>类型
					List<InquiryBusiCondition> busiConditions = JsonUtils.convertCollection(value.toString(), List.class, null, InquiryBusiCondition.class);
					order.setBusiConditions(busiConditions);
					continue;
				}
				
				Field field = null;
				// 先从本类中获取，如果获取不到则从父类中获取，父类获取不到则抛出异常提示解析询价单参数失败
				try {
					field = PurOrder.class.getDeclaredField(fieldName);
				} catch (NoSuchFieldException e) {
					field = PurOrder.class.getSuperclass().getDeclaredField(fieldName);
				}
				ReflectUtils.setValue(order, fieldName, JsonUtils.convertValue(value.toString(), field.getType()));
				
			}
			if (StringUtils.isNotBlank(targetJson)) {
				setTargetFromValue(order);
			}
			if (StringUtils.isNotBlank(itemsJson)) {
				setItemsFromValue(order);
			}
			if (StringUtils.isNotBlank(mouldJson)) {
				setMouldFromValue(order);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new CommonException("解析询价单参数失败");
		}
		return order;
	}
	
	private TemplateConf geTemplateConf(PurOrder order){
		if (templateConf != null) {
			return templateConf;
		}
		
		this.templateConf = SpringContextHolder.getOneBean(TemplateConfServiceImpl.class).queryObjById(order.getTemplateId());
		return this.templateConf;
	}

	private void setMouldFromValue(PurOrder order) throws JsonParseException, JsonMappingException, IOException {
		TemplateConf templateConf = this.geTemplateConf(order);
		Class<? extends IMould> clazz = templateConf.getMouldClass();
	
		JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, clazz);
		List<IMould> moulds = JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(mouldJson, javaType);
		order.setMouldList(moulds);
	}

	private void setTargetFromValue(PurOrder order) throws ClassNotFoundException, InstantiationException,
			IllegalAccessException, JsonParseException, JsonMappingException, IOException {
		TemplateConf templateConf = this.geTemplateConf(order);
		Class<? extends ITarget> clazz = templateConf.getTargetClass();
		
		JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, clazz);
		List<ITarget> targets = JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(targetJson, javaType);
		order.setTargetList(targets);

	}
	
	private void setItemsFromValue(PurOrder order ) throws ClassNotFoundException, InstantiationException,
	IllegalAccessException, JsonParseException, JsonMappingException, IOException {
		TemplateConf templateConf = this.geTemplateConf(order);
		Class<? extends IOrderItem> clazz = templateConf.getOrderItemClass();
		
		JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, clazz);
		List<IOrderItem> items = JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(itemsJson, javaType);
		order.setItemList(items);
	}

}
