package com.els.base.inquiry.utils.json;

import java.io.IOException;

import com.els.base.inquiry.enumclass.ReadWriteTypeEnum;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

public class ReadWriteTypeDeSerializer extends JsonDeserializer<String> {

	@Override
	public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		Boolean value = p.getValueAsBoolean();
		if (value) {
			return ReadWriteTypeEnum.BOTH_TYPE.getCode();
		}else{
			return ReadWriteTypeEnum.PUR_TYPE.getCode();
		}
	}


}
