package com.els.base.inquiry.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.service.InformationRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="询报价-信息记录表")
@Controller
@RequestMapping("informationRecord")
public class InformationRecordController {
    @Resource
    protected InformationRecordService informationRecordService;

    @ApiOperation(httpMethod="POST", value="创建询报价-信息记录表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody InformationRecord informationRecord) {
        Assert.isNotNull(informationRecord, "传入的信息记录为空");
        Assert.isNotBlank(informationRecord.getPurOrderId(), "采购商表头ID为空");
        Assert.isNotBlank(informationRecord.getFactoryCode(), "工厂代码为空");
        Assert.isNotBlank(informationRecord.getConditionalType(), "条件类型为空");
        Assert.isNotBlank(informationRecord.getPurchaseOrganization(), "采购组织为空");
        Assert.isNotBlank(informationRecord.getPurchasingGroup(), "采购组为空");
        Assert.isNotBlank(informationRecord.getInformationRecordCategory(), "信息记录类别为空");
    	this.informationRecordService.addObj(informationRecord);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-信息记录表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody InformationRecord informationRecord) {
        Assert.isNotBlank(informationRecord.getId(), "id 为空，保存失败");
        this.informationRecordService.modifyObj(informationRecord);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-信息记录表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.informationRecordService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-信息记录表")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 InformationRecord", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<InformationRecord>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        InformationRecordExample example = new InformationRecordExample();
        example.setPageView(new PageView<InformationRecord>(pageNo, pageSize));
        
        InformationRecordExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<InformationRecord> pageData = this.informationRecordService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}